
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

InterArrival _ function(time, TIMESTAMP.OPTION="pac.end") {
  ##
  ## a simple function of computing InterArrival time
  ## give arrival time.
  ##
  x <- diff(time)
  if(TIMESTAMP.OPTION=="pac.end") {
    x <- c(x[1], x)
  } else if(TIMESTAMP.OPTION=="pac.start") {
    x <- c(x, x[length(x)])
  } else {
    stop("Wrong value in TIMESTAMP.OPTION! it should be either pac.start or pac.end.")
  }
  ## round(x, 6)     ## force this to have micro-sec resolution
  x
}
