
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## $Id: addtolist.R,v 1.1 2002/01/16 22:40:59 dxsun Exp $

addtolist _ function(listName, object, itemName=NULL, sepObj=F) {
  ##
  ## list:   a character string for the name of the list
  ## object: can be a real object or name of an object
  ## name:   optional, serves as the name of the list
  ##         if not specified, use the next sequence number
  ##         if name already exists, replace it
  ## sepObj: if TRUE, save separate objects using listName.itemName
  ##
  
  if(F) {
    addtolist("myLst", 1:20)
    addtolist("myLst", 1:20, "first")
    addtolist("myLst", 1:20, "2nd")
    addtolist("myLst", 1:20, "first", sepObj=T)
    addtolist("myLst", 1:20, "2nd", sepObj=T)

    for(i in 1:10) addtolist("myLst", runif(1000000), "first")
    
  }

  ## if(is.character(object)) object _ get(object, inherit=T)
  if(is.character(object)) object _ oget(object)

  if(!sepObj) {
    if(is.null(oget(listName))) {
      ## assign(listName, list(), where=1, immediate = T)
      osave(listName, list())
    }
    
    ## listObj _ get(listName, inherit=T)
    listObj _ oget(listName)
    n0 _ length(listObj)
    
    if(is.null(itemName)) itemName _ paste(length(listObj)+1)
    if(F) {
      ## This is a bug in S:
      mylst _ list()
      mylst[["tcppac.2000.06.25.h03.m55.60.util.0.95"]] _ "New Item"
      names(mylst)
      mylst[["tcppac.2000.06.25.h03.m55.60.util.0.9"]]
    }
    if(!is.na(match(itemName, names(listObj)))) {
      cat(listName,"$", itemName,
          " already exist, it will be replaced\n", sep="")
    }
    
    listObj[[itemName]] _ object
    n1 _ length(listObj)
    
    ## assign(listName, listObj, where=1, immediate = T)
    osave(listName, listObj)
    cat("length(",listName,"): ", n0, " -> ",n1,"\n", sep="")
  } else {
    if(is.null(itemName)) {
      stop("itemName must be specified when using sepObj option")
    }
    listName _ paste(listName, itemName, sep=".")
    if(exists(listName)) {
      cat(listName, " already exist, it will be replaced\n", sep="")
    }
    ## assign(listName, object, where=1, immediate = T)
    osave(listName, object)
    cat(">>> saving to ", listName, "\n", sep="")
  }
  ## print(gc())
  ## print(ls())
  NULL
}
