
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

altRunlen <- function(x, addedge=T, eqlen=F){
  ##find the alternating run length for binary series $x$.
  ##addedge: Add x[0]=1-x[1], and x[n+1]=1-x[n] to the series
  ##eqlen: remove possibly last element to make the alternating 
  ##       run lengths to have the same length.
  ##browser()
  if(F){
    x <- rbinom(100, size=1, prob=0.4)
    altRunlen(x)
  }

  xo <- as.numeric(x)
  if(addedge) x <- c(1-xo[1], xo, 1-xo[length(xo)]) else x <- xo
  n <- length(x)
  id0 <- (x==0)
  id1 <- (x==1)
  alt1 <- diff((1:n)[id0])-1
  alt1 <- alt1[alt1>0]
  alt0 <- diff((1:n)[id1])-1
  alt0 <- alt0[alt0>0]
  alt <-  list(runlen0=alt0, runlen1=alt1)

  ##equate the len of the two series if required.
  if(eqlen){
    l <- sapply(alt, length)
    if(l[1]<l[2]) alt[[2]] <- rev(rev(alt[[2]])[-1])
    if(l[2]<l[1]) alt[[1]] <- rev(rev(alt[[1]])[-1])
  }
  alt
}
