
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

as.data.frame.matrix _ function (x, row.names = NULL, optional = FALSE) {
  d <- dim(x)
  nrows <- d[1]
  ir <- seq(length = nrows)
  ncols <- d[2]
  ic <- seq(length = ncols)
  dn <- dimnames(x)
  row.names <- dn[[1]]
  collabs <- dn[[2]]
  if (any(empty <- nchar(collabs) == 0)) 
    collabs[empty] <- paste("V", ic, sep = "")[empty]
  value <- vector("list", ncols)
  ## if (mode(x) == "character" || mode(x) == "logical") {
  ##   for (i in ic) value[[i]] <- as.factor(x[, i])
  ## }
  ## else {
  ##   for (i in ic) value[[i]] <- as.vector(x[, i])
  ## }
  for (i in ic) value[[i]] <- as.vector(x[, i])
  if (length(row.names) != nrows) 
    row.names <- if (optional) 
      character(nrows)
    else as.character(ir)
  if (length(collabs) == ncols) 
    names(value) <- collabs
  else if (!optional) 
    names(value) <- paste("V", ic, sep = "")
  attr(value, "row.names") <- row.names
  class(value) <- "data.frame"
  value
}
