
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

getcnt <- function(obj, timeunit=0.01){
  ##obtain byte counts from obj
  ##obj has to have a 'time', and 'len' column
  ##compute the packet count in time units of <timeunit>
  if(F){
    obj <- pactl.lohi500.5min.i001.flow.2000.01.02.h07.alltcp.5min
    obj$len <- obj$len+40
    out <- getcnt(obj, timeunit=0.1)
  }

  if(is.character(obj)) obj <- get(obj)
  tm0 _ min(obj$time)
  tm <- obj$time - tm0
  
  int.tm <- floor(tm/timeunit)
  int.tm <- factor(int.tm, levels=(min(int.tm):max(int.tm)))

  ##packet/byte counts
  pkt.tab <- tapply(rep(1,nrow(obj)), int.tm, sum)
  pkt.tab[is.na(pkt.tab)] <- rep(0, sum(is.na(pkt.tab)))
  byt.tab <- tapply(obj$len, int.tm, sum)
  byt.tab[is.na(byt.tab)] <- rep(0,sum(is.na(byt.tab)))
  
  out <- data.frame(time=as.numeric(names(pkt.tab))*timeunit+tm0,
		    pktcnt=drop.names(c(pkt.tab)),
		    bytcnt=drop.names(c(byt.tab)))
  dimnames(out)[[1]] <- 1:nrow(out)
  out
}
