
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

##some routines for marginal distribution 

tailProb <- function(x, correction=T, discrete=F, q=c()){
  ##find the tail prob P(x>x) either for discrete or continuous variable.
  ##make the 0.5 correction for continuity if required.
  ##x: observations
  ##correction: only valid if q is not supplied.
  ##q: supplied quantiles. If null, then use all observations instead.
  if(F) {
    out <- tailProb(x=rnorm(100)) #example 1
    out <- tailProb(x=rpois(100,lambda=3),discrete=T, correction=F)
    out <- tailProb(x=runif(10000), 
		    q = c(0.8, 1.2, 0.1, 0.4, 0.8))
    out <- tailProb(x=c(1, 2, 3, 4, 5), 
		    q = c(-1, 0, 0.5, 2, 2.5, 2.8, 2, 4))
  }
  
  ##browser()
  if(length(q)==0){
    nx <- length(x)
    if(discrete){
      p <- table(x)
      x1 <- sort(as.numeric(names(p)))
      p <- p[order(x1)] 
      if(!correction) tp <- (nx-cumsum(p))/nx  
      else tp <- (nx-cumsum(p)+0.5)/nx	#tp = P(X>k) 
      names(tp) <- NULL
      names(p) <- NULL
      out <- list(x=x1, tp=tp, p=p/nx)
    } else {
      cp <- ((1:nx)-0.5)/nx		#cumulative prob.
      out <- list(x = sort(x), tp = 1-cp)
    }
  }
  if(length(q)>0){
    ##browser()
    qorig <- q
    tp <- rep(0,length(qorig))
    rx <- range(x)
    id <- (qorig>=rx[1] & qorig<rx[2])
    tp[qorig>=rx[2]] <- 0
    tp[qorig<rx[1]] <- 1

    qOK <- qorig[id]
    if(any(duplicated(qOK))) {
      cat("some elements in q are duplicated \n")
      q <- unique(qOK)
    } else q <- qOK
    qsort <- sort(q)
    nq <- length(q)
    newq <- c(rx[1]-1, qsort, rx[2]+1)
    px <- cut(x, breaks = newq)
    px <- factor(as.numeric(px), levels=1:length(levels(px)))
    px <- table(px)/length(x)
    px <- px[1:nq]
    tpx <- 1 - cumsum(px)
    names(tpx) <- qsort
    tp[id] <- tpx[as.character(qOK)]
    out <- list(x=qorig, tp=tp)
  }
  out
}

cumProb <- function(x, correction=T, discrete=F, q=c()){
  ##same as tailProb, but give the cumulative probability P(x<=x) instead.
  if(F) {
    out <- cumProb(rnorm(100)) #example 1
    out <- cumProb(rpois(100,lambda=3), discrete=T, correction=F)
    out <- tailProb(x=runif(10000), 
		    q = c(0.8, 1.2, 0.1, 0.4, 0.8))
  }
  out <- tailProb(x)
  out$cp <- 1-out$tp
  out$tp <- NULL
  out
}

