
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

flattenList _ function(lst) {
  ## 
  ## similar to unlist, but more flexible in keeping component names
  ## assuming the list has names in all levels
  ##
  ##     O                  O
  ##    / \            /    |    \ 
  ##   A1  A2    =>   A1$B1 A1$B2 A2
  ##  / \
  ## B1  B2
  ##
  ## returns a list with only one layer or the original object if it is not a
  ##   list to start with
  ##
  if(F) {
    lst _ list(rate=1:5, fit=list(para=runif(4), type="New")); names(lst)
    lst2 _ flattenList(lst); names(lst2)
    flattenList(list(x=1, y=2))
    flattenList(1:10)
   
  }
  if(is.list(lst)) {
    newlst _ list()
    for(nm in names(lst)) {
      if(is.list(lst[[nm]])) {
        tmplst _ flattenList(lst[[nm]])
        for(tmpnm in names(tmplst))
          newlst[[paste(nm,tmpnm,sep="$")]] _ tmplst[[tmpnm]]
      } else {
        newlst[[nm]] _ lst[[nm]]
      }
    }
    return(newlst)
  } else {
    return(lst)
  }
}

extractList _ function(lst, comp) {
  ##
  ## $id: extractlist.s,v 1.4 2001/01/05 21:03:51 dxsun exp $
  ## $source: /packet/cvsroot/snetanalysis/extractlist.s,v $
  ##
  ## note: it is easier to use sapply.extractList() for converting
  ##       output to a data.frame.
  ## 
  if(F) {
    lst _ list(fit=list(para=list(d=.75, varratio=0.89)),
               weibull.me=list(shape=0.8, scale=0.6, label="demo"))
    comp _ c("d", "varratio", "shape","label")
    extractList(lst, comp)
    unlist(extractList(lst, comp))
  }
  ## vec _ unlist(lst)
  vec _ flattenList(lst)
  ## index _ rep(NA, length(comp))
  newvec _ list()
  for(i in 1:length(comp)) { ## i _ 1
    index.match _ seq(vec)[regexpr(paste('\\$', comp[i], '$', sep=""), names(vec))!=-1]
    if(length(index.match)<1) {
      index.match _ seq(vec)[regexpr(paste(comp[i], '$', sep=""), names(vec))!=-1]
    }
    if(length(index.match)<1) {
      index.match _ seq(vec)[regexpr(paste(comp[i]), names(vec))!=-1]
    }
    ## index.match
    if(length(index.match)<1) {
      cat("Warning: no match for", comp[i], "\n")
    } else {
      if(length(index.match)>1) {
        cat("Warning: multiple match found:", names(vec)[index.match], "for", comp[i], "\n")
        nc _ nchar(names(vec)[index.match])
        index.match _ index.match[nc == min(nc)]
        if(length(index.match)>1) { ## really a problem
          stop("Multiple match not allowed")
        }
      }
      newvec[[comp[i]]] _ vec[[index.match]]
    } 
  }
  newvec
}

