
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

##
## $Id: fit.fsd.log10spec.R,v 1.2 2002/03/05 06:53:39 dxsun Exp $
## $Source: /packet/CVSRoot/SNet_R/SNet/R/fit.fsd.log10spec.R,v $
##

## 2/23/00
## fit the final model used in the paper
## spec(log.intArriv) = sigmga(epsilon)^2 * spec((ARIMA(0,d,1)) + sigma(n)^2

## fit.log10spec _ function(x, init=NULL, type="p3",
##                          p2a.d=NULL) {
##   ## 
##   ## use type = "p3", "p2", "p1"
##   ## p3: optimize for varRatio, d, sigma.lSq
##   ## p2a: optimize for varRatio, sigma.lSq
##   ## p2: optimize for varRatio, d
##   ## p1: optimize for varRatio
##   ##
##   ## fit log2(intArriv) using log10( spec(log2(intArriv)) )
## 
##   if(F) {
##     ## objNm=lohi508.intvl.olst[[20]]
##     ## flow <- get(objNm); dim(flow)
##     d <- 0.25; x <- fracdiff.sim(n=500, ar=0, ma=-1, d=d)$series
##     fit _ fit.log10spec(x)
##     plot(fit$freqseq, fit$log10spec.obs, pch=".")
##     lines(fit$freqseq, fit$log10spec.fitted, col=3)
##     fit$para
##   }
## 
##   ## define functions
##   get.var.farima.0.d.1 _ function(d) {
##     ## get.var.farima.0.d.1(.25) - 3.147575
##     ## get.var.farima.0.d.1(.49) - 64.15799
##     val _ (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
##     return(val)
##   }
## 
##   fit.objective.p3 _ function(para, compute.log10spec=F) {
##     ## 
##     ## varRatio, d, sigma.lSq
##     ## 
##     ## global variable "fit.globvar":
##     ##   log10spec.obs, freqseq
##     varRatio _ para[1]
##     d _ para[2]
##     sigma.lSq _ para[3]
## 
##     ## fit.globvar _ get("fit.globvar", inherit=T)
##     log10spec.obs _ fit.globvar$log10spec.obs
##     freqseq _ fit.globvar$freqseq
##   
##     sigma.nSq _ sigma.lSq * varRatio
##     ## 3*gamma(3.4)/(4*gamma(1/2)) is 1.26147420930901
##     ## Cd _ (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
##     Cd _ get("get.var.farima.0.d.1",inherit=T)(d)
##     sigma.epsSq _  1/Cd * (1-varRatio) * sigma.lSq
##   
##     ## 1. spec of ARIMA(0,d,1)
##     spec.fitted _ (spec.eval(c(1,-1),freqseq)$spec) ^ (-d)## (1-B)^d
##     spec.fitted _ spec.fitted * (spec.eval(c(1,1),freqseq)$spec)## MA(1)
## 
##     ## 2. spec of lj
##     spec.fitted _ spec.fitted * sigma.epsSq + sigma.nSq
## 
##     log10spec.fitted _ log10(spec.fitted)
##     if(compute.log10spec) return(log10spec.fitted)
## 
##     val _ mean((log10spec.fitted - log10spec.obs)^2)
##     cat("obj:", val, "\n")
##     val
##   }
## 
##   fit.objective.p2 _ function(para, compute.log10spec=F) {
##     ## simplified model, only parameter is varRatio
##     varRatio _ para[1]
##     d _ para[2]
##     ## fit.globvar _ get("fit.globvar", inherit=T)
##     sigma.lSq _ fit.globvar$sigma.lSq
##     get("fit.objective.p3",inherit=T)(
##                              c(varRatio, d, sigma.lSq), compute.log10spec)
##   }
## 
##   fit.objective.p2a _ function(para, compute.log10spec=F) {
##     ## simplified model, only parameter is varRatio
##     varRatio _ para[1]
##     ## d _ para[2]
##     sigma.lSq _ para[2]
##     ## fit.globvar _ get("fit.globvar", inherit=T)
##     ## sigma.lSq _ fit.globvar$sigma.lSq
##     d _ fit.globvar$d
##     get("fit.objective.p3",inherit=T)(
##                              c(varRatio, d, sigma.lSq), compute.log10spec)
##   }
## 
##   fit.objective.p1 _ function(para, compute.log10spec=F) {
##     ## simplified model, only parameter is varRatio
##     varRatio _ para[1]
##     ## fit.globvar _ get("fit.globvar", inherit=T)
##     d _ fit.globvar$d
##     sigma.lSq _ fit.globvar$sigma.lSq
##     get("fit.objective.p3",inherit=T)(
##                              c(varRatio, d, sigma.lSq), compute.log10spec)
##   }
##   
##   log2intArriv _ x
##   ## log2intArriv _ log2(intArriv)
##   spec _ smooth.spec(log2intArriv, smooth.m=5)
##   fit.globvar _ list(log10spec.obs=log10(spec$spec),
##                      freqseq=spec$freq)
## 
##   if(is.null(init)) {
##     if(F) {
##       mle _ weibull.MLE(2^log2intArriv)
##       sigma.lSq.init _ pi^2/(6*mle$shape^2)/(log(2)^2)
##     } else {
##       me _ weibull.ME(2^log2intArriv)
##       sigma.lSq.init _ pi^2/(6*me$shape^2)/(log(2)^2)
##     }
##     varRatio.init _ .5
##     d.init _ 0.25
##   } else {
##     varRatio.init _ init$varRatio
##     d.init _ init$d
##     sigma.lSq.init _ init$sigma.lSq
##   }
##   
##   cat(">>> type:", type, "\n")
##   fit.objective _ get(paste("fit.objective", type, sep="."))
## 
##   if(type =="p3") {
##     para.init _ c(varRatio.init, d.init, sigma.lSq.init)
##     para.lo _   c(0            , 0     , 0             )
##     para.hi _   c(1            , 0.499 , Inf           )
##   } else if(type =="p2") {
##     fit.globvar$sigma.lSq _ sigma.lSq.init
##     para.init _ c(varRatio.init, d.init)
##     para.lo _   c(0            , 0     )
##     para.hi _   c(1            , 0.499 )
##   } else if(type =="p2a") {
##     if(!is.null(p2a.d)) d.init _ p2a.d
##     fit.globvar$d _ d.init
##     para.init _ c(varRatio.init, sigma.lSq.init)
##     para.lo _   c(0            , 0             )
##     para.hi _   c(1            , Inf           )
##   } else if(type =="p1") {
##     fit.globvar$sigma.lSq _ sigma.lSq.init
##     fit.globvar$d _ d.init
##     para.init _ c(varRatio.init)
##     para.lo _   c(0            )
##     para.hi _   c(1            )
##   }
##   
##   cat(">>> start L-BFGS-B optim() optimization...\n")
##   ## fit _ nlminb(objective=fit.objective, start=para.init, lower=para.lo, upper=para.hi)
##   fit _ optim(fn=fit.objective, par=para.init, lower=para.lo, upper=para.hi,
##               method="L-BFGS-B")
##   if(fit$value > fit.objective(para.init)) {
##     cat(">>> change to Nelder-Mead optim() optimization...\n")
##     fit _ optim(fn=fit.objective, par=para.init, method="Nelder-Mead")
##   }
##   para _ c(varRatio.init, d.init, sigma.lSq.init)
##   ## para[1:length(fit$par)] _ fit$par
##   if(type =="p2a") {
##     para[c(1,3)] _ fit$par
##   } else {
##     para[1:length(fit$par)] _ fit$par
##   }
##   
##   names(para) _ c("varRatio", "d", "sigma.lSq")
##   log10spec.fitted _ fit.objective(fit$par, compute.log10spec=T)
##   obj _ fit.objective(fit$par)
## 
##   list(freqseq = fit.globvar$freqseq,
##        log10spec.obs = fit.globvar$log10spec.obs,
##        log10spec.fitted = log10spec.fitted,
##        para=para, obj=obj,
##        n=length(log2intArriv))
## }

fit.fsd.log10spec.unbiased _ function(x, log10spec.obs.lst, 
				  spec.pgram.arg=list(),
				  init=NULL, type="p3",
				  p2a.d=NULL, 
				  freq.var=c(0.01,0.025,0.05)) {
  ## similar to fit.log10spec, but correct for the bias of the log10.spec
  ## 
  ## use type = "p3", "p2", "p1"
  ## p3: optimize for varRatio, d, sigma.lSq
  ## p2a: optimize for varRatio, sigma.lSq
  ## p2: optimize for varRatio, d
  ## p1: optimize for varRatio
  ##
  ## fit log2(intArriv) using log10( spec(log2(intArriv)) )
  
  cat(">>> start fit.fsd.log10spec.unbiased\n");
  print(length(x))

  if(F) {
    ##for farima.0.d.1 + noise model
    ##d <- 0; x <- arima.sim(model=list(ma=-1), n=1e4)
    ##d <- 0.25; x <- arima.fracdiff.sim(model=list(d=d, ma=-1), n=1e4)
    d <- 0.25; x <- fracdiff.sim(n=500, ar=0, ma=-1, d=d)$series
    vx <- (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
    x <- x/sqrt(vx)
    varRatio <- 0.5
    y <- x*sqrt(1-varRatio)+rnorm(length(x))*sqrt(varRatio)

    fit1 <- fit.fsd.log10spec.unbiased(y,init=list(varRatio=0.5,d=0.1,sigma.lSq=1))
    fit1.p2 <- fit.fsd.log10spec.unbiased(y,init=list(varRatio=0.5,
					 d=0.1,sigma.lSq=1),type="p2")
    fit2 <- fit.fsd.log10spec.unbiased(y,init=list(varRatio=0.5,
					 d=0.1,sigma.lSq=1),
				      spec.pgram.arg=list(taper=0.5))
    fit2.p2 <- fit.fsd.log10spec.unbiased(y,init=list(varRatio=0.5,
					    d=0.1,sigma.lSq=1),type="p2", 
				      spec.pgram.arg=list(taper=0.5))
    round(cbind(true=c(varRatio,d,1), fit=fit$para, fit.p2=fit.p2$para,
		fit.unbiased=fit1$para, fit.unbiased.p2=fit1.p2$para,
		fit.unbiased.taper=fit2$para, 
		fit.unbiased.p2.taper=fit2.p2$para),digit=3)
    
    #x missing, log10spec.obs.lst known
    d <- 0; x <- fracdiff.sim(n=500, ar=0, ma=-1, d=d)$series
    fit  <- fit.fsd.log10spec.unbiased(x, 
				   init=list(varRatio=0.5,d=0.1,sigma.lSq=1),
				   type="p2")
    fit1 <- fit.fsd.log10spec.unbiased(log10spec.obs.lst=
				   list(freqseq=fit$freqseq,
					log10spec.obs=fit$log10spec.obs),
				   init=list(varRatio=0.5,d=0.1,sigma.lSq=1),
				   type="p2")
    
    round(cbind(fit=fit$para, fit1=fit1$para, fit2=fit2$para),digit=2)
    round(cbind(fit.etp=fit$etp, fit.etp.fit=fit$etp.fit, 
                fit1.etp=fit1$etp, fit1.etp.fit=fit1$etp.fit), digit=4)
    
  }

  ## define functions
  get.var.farima.0.d.1 _ function(d) {
    ## get.var.farima.0.d.1(.25) - 3.147575
    ## get.var.farima.0.d.1(.49) - 64.15799
    val _ (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
    return(val)
  }

  fit.objective.p3 _ function(para, compute.log10spec=F) {
    ## 
    ## varRatio, d, sigma.lSq
    ## 
    ## global variable "fit.globvar":
    ##   log10spec.obs, freqseq, bias, df
    varRatio _ para[1]
    d _ para[2]
    sigma.lSq _ para[3]

    ## fit.globvar _ get("fit.globvar", inherit=T)
    log10spec.obs _ fit.globvar$log10spec.obs
    freqseq _ fit.globvar$freqseq
  
    sigma.nSq _ sigma.lSq * varRatio
    ## 3*gamma(3.4)/(4*gamma(1/2)) is 1.26147420930901
    ## Cd _ (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
    Cd _ get("get.var.farima.0.d.1",inherit=T)(d)
    sigma.epsSq _  1/Cd * (1-varRatio) * sigma.lSq
  
    ## 1. spec of ARIMA(0,d,1)
    spec.fitted _ (spec.eval(c(1,-1),freqseq)$spec) ^ (-d)## (1-B)^d
    spec.fitted _ spec.fitted * (spec.eval(c(1,1),freqseq)$spec)## MA(1)

    ## 2. spec of lj
    spec.fitted _ spec.fitted * sigma.epsSq + sigma.nSq

    log10spec.fitted _ log10(spec.fitted)
    if(compute.log10spec) return(log10spec.fitted)

    val _ mean((log10spec.fitted - log10spec.obs)^2)
    cat(">>> fit.fsd.log10spec.unbiased/obj:", val, "\n")
    if(!is.finite(val)) val _ 1e100
    val
  }

  fit.objective.p2 _ function(para, compute.log10spec=F) {
    varRatio _ para[1]
    d _ para[2]
    ## fit.globvar _ get("fit.globvar", inherit=T)
    sigma.lSq _ fit.globvar$sigma.lSq
    get("fit.objective.p3",inherit=T)(
                             c(varRatio, d, sigma.lSq), compute.log10spec)
  }

  fit.objective.p2a _ function(para, compute.log10spec=F) {
    ## simplified model,
    varRatio _ para[1]
    ## d _ para[2]
    sigma.lSq _ para[2]
    ## fit.globvar _ get("fit.globvar", inherit=T)
    ## sigma.lSq _ fit.globvar$sigma.lSq
    d _ fit.globvar$d
    get("fit.objective.p3",inherit=T)(
                             c(varRatio, d, sigma.lSq), compute.log10spec)
  }

  fit.objective.p1 _ function(para, compute.log10spec=F) {
    ## simplified model, only parameter is varRatio
    varRatio _ para[1]
    fit.globvar _ get("fit.globvar", inherit=T)
    d _ fit.globvar$d
    sigma.lSq _ fit.globvar$sigma.lSq
    get("fit.objective.p3",inherit=T)(
			       c(varRatio, d, sigma.lSq), compute.log10spec)
  }

  if(!missing(x)) {nx <- length(x)} else nx <- NA   
  ##prepare the raw periodogram estimate
  if(missing(log10spec.obs.lst)){
    if(!missing(x)){
      m <- 5
      spec _ smooth.spec(x, smooth.m=m, 
			 spec.pgram.arg=spec.pgram.arg)
      if(is.null(spec)) return()
      nu <- spec$df/2 ##df: chisq df, nu: equivalent shape parameter for gamma
      bias _ (digamma(nu)-log(nu))/log(10)
      fit.globvar _ list(freqseq=spec$freq, 
			 log10spec.obs.unbiased=log10(spec$spec)-bias)
    } else {stop("missing either x or log10spec.obs.lst")}
  } else fit.globvar _ log10spec.obs.lst

  if(!missing(x) && is.null(init)) {
    if(F) {
      mle _ weibull.MLE(2^x)
      sigma.lSq.init _ pi^2/(6*mle$shape^2)/(log(2)^2)
    } else {
      me _ weibull.ME(2^x)
      sigma.lSq.init _ pi^2/(6*me$shape^2)/(log(2)^2)
    }
    varRatio.init _ .5
    d.init _ 0.25
  } else {
    varRatio.init _ init$varRatio
    d.init _ init$d
    sigma.lSq.init _ init$sigma.lSq
  }
  
  cat(">>> type:", type, "\n")
  fit.objective _ get(paste("fit.objective", type, sep="."))

  if(type =="p3") {
    para.init _ c(varRatio.init, d.init, sigma.lSq.init)
    para.lo _   c(0            , 0     , 0             )
    para.hi _   c(1            , 0.499 , Inf           )
  } else if(type =="p2") {
    fit.globvar$sigma.lSq _ sigma.lSq.init
    para.init _ c(varRatio.init, d.init)
    para.lo _   c(0            , 0     )
    para.hi _   c(1            , 0.499 )
  } else if(type =="p2a") {
    if(!is.null(p2a.d)) d.init _ p2a.d
    fit.globvar$d _ d.init
    para.init _ c(varRatio.init, sigma.lSq.init)
    para.lo _   c(0            , 0             )
    para.hi _   c(1            , Inf           )
  } else if(type =="p1") {
    fit.globvar$sigma.lSq _ sigma.lSq.init
    fit.globvar$d _ d.init
    para.init _ c(varRatio.init)
    para.lo _   c(0            )
    para.hi _   c(1            )
  }
  
  cat(">>> start L-BFGS-B optim()\n")
  ## fit _ nlminb(objective=fit.objective, start=para.init, lower=para.lo, upper=para.hi)
  fit _ optim(par=para.init, fn=fit.objective, lower=para.lo, upper=para.hi,
              method="L-BFGS-B")
  cat(">>> after L-BFGS-B optim()\n")
  if(fit$value > fit.objective(para.init)) {
    cat(">>> change to Nelder-Mead optim() optimization...\n")
    fit _ optim(fn=fit.objective, par=para.init, method="Nelder-Mead")
  }
  para _ c(varRatio.init, d.init, sigma.lSq.init)
  ## para[1:length(fit$par)] _ fit$par
  if(type =="p2a") {
    para[c(1,3)] _ fit$par
  } else {
    para[1:length(fit$par)] _ fit$par
  }

  names(para) _ c("varRatio", "d", "sigma.lSq")
  log10spec.fitted _ fit.objective(fit$par, compute.log10spec=T)
  obj _ fit.objective(fit$par)

  cat(">>> step 1\n");
  ##entropy  
  etp <- entropy(freq=fit.globvar$freqseq, 
		 spec=10^fit.globvar$log10spec.obs.unbiased)
  cat(">>> step 2\n");
  etp.fit <- entropy.model(para)
  ##n-step prediction error
  cat(">>> step 3\n");
  twostep.pred.err <- drop.names(nstep.predict.err(freq=fit.globvar$freqseq, 
		       spec=10^fit.globvar$log10spec.obs.unbiased)["twostep"])
  cat(">>> step 4\n");
  twostep.pred.err.fit <- drop.names(nstep.predict.err.model(para)["twostep"])

  cat(">>> fit.fsd.log10spec.unbiased: after nstep.predict.err()\n")
  ##variance ratio of low frequency part [0, f]
  var.freq <- initialList(paste("var.freq", freq.var, sep="."))
  sp <- (10^fit.globvar$log10spec.obs.unbiased)
  sp <- sp / mean(sp)
  for(i in 1:length(freq.var)){
    var.freq[[i]] <- mean(sp[fit.globvar$freqseq<=freq.var[i]])*freq.var[i]*2
  }

  list(freqseq = fit.globvar$freqseq,
       log10spec.obs.unbiased = fit.globvar$log10spec.obs.unbiased, 
       log10spec.fitted = log10spec.fitted,
       para=as.list(para), obj=obj, 
       etp=etp, etp.fit=etp.fit, 
       twostep.pred.err=twostep.pred.err, 
       twostep.pred.err.fit=twostep.pred.err.fit, 
       var.freq=var.freq, 
       n=nx)
}

if(F) {
  freqseq <- seq(0, 0.5, length = 1000)[-1]
  d _ .456
  Cd _ get("get.var.farima.0.d.1",inherit=T)(d)
  spec.fitted <- (spec.eval(c(1, -1), freqseq)$spec)^(-d)
  spec.fitted _ spec.fitted  / mean(spec.fitted)
  log10.spec.fitted <- log10(spec.fitted)
  plot(freqseq, log10.spec.fitted, type="l")

  d _ .45
  Cd _ get("get.var.farima.0.d.1",inherit=T)(d)
  spec.fitted2 <- (spec.eval(c(1, -1), freqseq)$spec)^(-d)
  spec.fitted2 _ spec.fitted2  / mean(spec.fitted2)
  log10.spec.fitted2 <- log10(spec.fitted2)
  lines(freqseq, log10.spec.fitted2, col=3)

  plot(freqseq, log10.spec.fitted - log10.spec.fitted2)
  
}

