
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

gaussianize <- function(x) {
  if(F) {
    x _ runif(500000)
    x2 _ gaussianize(x)
    
    date(); x3 _ qnorm((rank(x) - 0.5)/length(x)); date()      ## 36sec
    date(); x2 _ qnorm((rank.fast(x) - 0.5)/length(x)); date() ## 8sec
    ## with rank():      36sec
    ## with rank.fast(): 8sec
  }

  ## this is 4 times slower based on 500000 points!
  ## x.trans _ qnorm((rank(x)-0.5)/length(x)) 

  ## difference between rank() and order()
  ## rank() gives average rank in case of ties, same value gives same rank
  ## order() gives a permutation that sort the vector,
  ##         different indexes enve for tied values
  ## rank() is what we want, but order() is much faster.
  
  ## if(!userank){
  ##   ord _ order(x)
  ##   n _ length(ord);
  ##   rk _ rep(0, n); rk[ord] _ seq(n)
  ##   p _ (rk-.5)/n; 
  ##   qnorm(p)
  ## } else qnorm((rank(x) - 0.5)/length(x))
  ## qnorm((rank.fast(x) - 0.5)/length(x))
  ## in S, rank() runs much slower than order(), but it
  ##   not a problem in R, so no need for rank.fast()
  qnorm((rank(x) - 0.5)/length(x))
}

standardize _ function(x) {
  (x - mean(x)) / sqrt(var(x))
}

sqrt.standardize _ function(x) {
  standardize(sqrt(x))
}


