
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

get.intvl.df _ function(objLst,
                        type = "pac",
                        TIMESTAMP.OPTION = "pac.end",
                        pacSize.type = "ETH.PAYLOAD",
                        LINKSPEED = 10^8
                        ) {
  ## Input:
  ## objLst: a list of objects (one for each analysis interval)
  ## type: pac or flow
  ## for "pac" type:
  ##   TIMESTAMP.OPTION: pac.end or pac.start
  ##   pacSize.type:     "ETH.PAYLOAD", "ETH.ETH", "ETH.IP", 
  ##                     "ATM/AAL5", "POS/PPP", "SIMU"
  ##   LINKSPEED:        in bits/sec
  ##
  task.samp.lst _ list()
  for(i in 1:length(objLst)) { ## i _ 1
    cat(i, " ", objLst[i], "\n");
    ## print(gc())
    ## print(ls())
    obj _ oget(objLst[i]); dim(obj);
    ##flowObjNm _ unix("sed 's/^tcppac.//'", objLst[i])
    ##flowObjNm _ unix("sed 's/.alltcp$//'", flowObjNm)
    ##flowObj _ get(flowObjNm)
    if(!is.null(obj$time)) {
      INTERVAL.WIDTH _ ceiling(diff(range(obj$time)))
    } else if(!is.null(obj$start)) {
      INTERVAL.WIDTH _ ceiling(diff(range(obj$start)))
    } else {
      cat(">>> no time variable available, unknown INTERVAL.WIDTH\n");
    }
    cat(i, "INTERVAL.WIDTH:", INTERVAL.WIDTH,"\n")
    task.samp.lst[[paste(i)]] _
      data.frame(objnme=I(objLst[i]),
                 rate=nrow(obj)/INTERVAL.WIDTH
                 ##flowrate=nrow(flowObj)/INTERVAL.WIDTH,
                 )
    ## osave("task.samp.lst", task.samp.lst)
    rm(list="obj")
  }
  ## oget("task.samp.lst")
  task.samp.df _ list2df(task.samp.lst)
  if(type=="pac") {
    task.samp.df$TIMESTAMP.OPTION _ rep(TIMESTAMP.OPTION, nrow(task.samp.df))
    task.samp.df$pacSize.type     _ rep(pacSize.type, nrow(task.samp.df))
    task.samp.df$LINKSPEED        _ rep(LINKSPEED, nrow(task.samp.df))
    nms _ names(task.samp.df); nms[nms=="rate"] _ "pacrate"
    names(task.samp.df) _ nms
  } else if(type=="flow") {
    nms _ names(task.samp.df); nms[nms=="rate"] _ "flowrate"
    names(task.samp.df) _ nms
  } 
  task.samp.df
}

