
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## ts.2000.1.1 <- 946702800.

if(F) {
  ts.2000.1.1 _
    0 - as.numeric((timestamp.EST(0) - timeDate("01/01/2000 00:00:00",zone="EST")))*24*3600
  ts.2000.1.1 _ as.numeric(as.POSIXct("2000-01-01 EST"))
  ts2POSIXct(ts.2000.1.1)
}

ts.2000.1.1 _ as.numeric(as.POSIXct("2000-01-01 EST"))

ts2POSIXct = function(ts) {
  ## POSIXct: calendar time, better when used in data frames
  ## POSIXlt: local time, better for human-readable forms
  ## POSIXt:  inherits from both POSIXct/POSIXlt
  if(F) {
    ts2POSIXct(946702800.)
  }
  structure(0, class = c("POSIXt", "POSIXct"))+ts
}

ts2intvl = function(tt, ref=ts.2000.1.1, width=5*60) {
  ## get interval index
  if(F) {
    ts2intvl(c(946702800, 946702872))
  }
  ceiling((tt - ref)/width)
}

intvl.label _ function(intvl, ref=ts.2000.1.1, width=5*60) {
  ## x _ data.frame(day=as.character(timestamp.EST(ref+(intvl-1/2) * width,
  ##                  format="%02m/%02d/%Y")),
  ##                intvl=paste("(",as.character(timestamp.EST(ref+(intvl-1) * width,
  ##                  format="%02H:%02M")),",",
  ##                  as.character(timestamp.EST(ref+(intvl) * width, format="%02H:%02M")),
  ##                  "]",sep=""))
  ## if(width<60) {
  ##   x$intvl=paste("(",as.character(timestamp.EST(ref+(intvl-1) * width,
  ##                  format="%02H:%02M:%02S")),",",
  ##                  as.character(timestamp.EST(ref+(intvl) * width, format="%02H:%02M:%02S")),
  ##     "]",sep="")
  ## }
  if(F) {
    intvl.label(ts2intvl(c(946702800, 946702872)))
  }
  x _ data.frame(day=format.POSIXct(ts2POSIXct(ref+(intvl-1/2) * width),
                   format="%02m/%02d/%Y"),
                 intvl=paste("(",
                   format.POSIXct(ts2POSIXct(ref+(intvl-1) * width), format="%02H:%02M"),",",
                   format.POSIXct(ts2POSIXct(ref+(intvl  ) * width), format="%02H:%02M"),
                   "]",sep=""))
  if(width<60) {
    x$intvl=paste("(",
                   format.POSIXct(ts2POSIXct(ref+(intvl-1) * width), format="%02H:%02M:%02S"),",",
                   format.POSIXct(ts2POSIXct(ref+(intvl  ) * width), format="%02H:%02M:%02S"),
                   "]",sep="")
  }
  x
}

## old.get.intvl.summary _ function(flowObj, INTVL.WIDTH = 5*60, ...) {
##   flowrate _ nrow(flowObj)/INTVL.WIDTH
##   intvlLab _ intvl.label(ts2intvl(flowObj$start[1], width=INTVL.WIDTH),
##                             width = INTVL.WIDTH)
##   intvlStr _ printf(list(...)$intvl, "%04d")
##   intvlLab _ paste(intvlStr,
##                    as.character(intvlLab$day[1]),
##                    as.character(intvlLab$intvl[1]), sep="-")
##   list(flowrate=flowrate, intvlLab = intvlLab, intvlStr=intvlStr, ...)
## }

get.intvl.summary _ function(starttime, INTVL.WIDTH = 5*60, fmt="%03d", ...) {
  ## given the starttime timestamp and intvl width (with optinal intvl index)
  ## get some text information about the intvls
  if(F) {
    get.intvl.summary(c(946802877))
    get.intvl.summary(c(946802800, 946802877))
    get.intvl.summary(c(946802800, 946802877), intvl=35)
  }
  intvlStr = printf(list(...)$intvl, fmt) 
  ## if(length(starttime)>1){
  intvlLab = intvl.label(ts2intvl(starttime[1], width=INTVL.WIDTH),
    width = INTVL.WIDTH)
  intvlLab = paste(intvlStr,
    as.character(intvlLab$day[1]),
    as.character(intvlLab$intvl[1]), sep="-")
  ## } else intvlLab = ""
  list(intvlLab = intvlLab, intvlStr=intvlStr, ...)
}
