
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

##
## $Id: getfile.R,v 1.1.1.1 2001/12/17 16:03:01 dxsun Exp $
##
## create a directory stack for searching files
## functions:
## pushd(), popd(), pwd(), getfile()
## using .sys.pwd as the directory stack
## using system functions file.exists()
## 

pwd _ function() {
## find the current virtual directory stack
  if(F) {
    print(pwd())
  }
  if( !exists(".sys.pwd") || length(.sys.pwd) == 1) { 
    ## assign(".sys.pwd", system("echo $PWD"), where=0);
    assign(".sys.pwd", getwd(), env = .GlobalEnv);
  }
  .sys.pwd
}

pushd _ function(path) {
## change virtual directory
  if(F) {
    pushd("/home/dxsun/Project/Packet")
  }
  if( !missing(path) ) {
    assign(".sys.pwd", unique(c(path, pwd())),  env = .GlobalEnv);
  }
  pwd()
}

popd _ function() {
## reverse pushd()
  if(F) {
    popd()
  }
  .sys.pwd _ pwd();
  pop.dir _ .sys.pwd[1]
  if(length(.sys.pwd)>1) {
    assign(".sys.pwd", .sys.pwd[-1],  env = .GlobalEnv);
  }
  pop.dir
}

getfile _ 
##
## search file name in the virtual paths
## if not found, try .Z and .gz as well if suffixSearch is given
##
function(file="", suffixSearch=c("gz","Z")) {
  if(F) {
    pushd("/usr/lib/R/library")
    getfile("R.css")
    getfile("base")
    getfile("wrongDir")
    popd()
  }
  ofile _ file
  found _ FALSE
  if( file != "" ) {
    if( !file.exists(file) ) {
      dir.stack _ pwd()
      for(dir in dir.stack) {
        if(!found) {
          n.file _ paste(dir, "/", file, sep="")
          if( file.exists(n.file) ) {
            file _ n.file;
            cat("using <", file, "> instead ...\n", sep="")
            found _ TRUE
            break; 
          } 
          if(length(suffixSearch)>0) {
            for(suffix in suffixSearch) {
              if(!found) {
                n.file _ paste(dir, "/", file, ".gz", sep="")
                if( file.exists(n.file) ) {
                  file _ n.file;
                  cat("using <", file, "> instead ...\n", sep="")
                  found _ TRUE
                  break; 
                }
              }
            }
          }
        }
      }
    }
  }
  
  if( !file.exists(file) ) {
    cat("file <", file, "> doesn't exist ...\n", sep="")
    return(NULL)
  }
  file
}
