
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

geweke.spec <- function(freqseq){4 * sin(pi * freqseq)^2}

geweke.smooth.log10spec <- 
  function(x, log10spec.obs.lst, 
	   spec.pgram.arg = list(), 
	   loess.arg = list(span=0.5, degree=2, family="gaussian", trace.hat=c("approximate")))
{
  #$Id: geweke.smooth.log10spec.R,v 1.2 2002/03/05 06:53:39 dxsun Exp $
  #$Source: /packet/CVSRoot/SNet_R/SNet/R/geweke.smooth.log10spec.R,v $
  #non-parametric smoothing based on geweke spectrum 
  #transformation. In addition, give the spectrum estimate
  #at 500 equally spaced frequency points.
  if(F){
    ## for farima.0.d.1 + noise model
    ## d <- 0; x <- arima.sim(model = list(ma = -1), n = 10000.)
    ## d <- 0.25; x <- arima.fracdiff.sim(model=list(d=d, ma=-1), n = 500.)
    d <- 0.25; x <- fracdiff.sim(n=500, ar=0, ma=-1, d=d)$series
    vx <- ((2 + (2 * d)/(1 - d)) * gamma(1 - 2 * d))/((gamma(1 - d))^2)
    x <- x/sqrt(vx)
    varRatio <- 0.5
    y <- x * sqrt(1 - varRatio) + rnorm(length(x)) * sqrt(varRatio)
    y <- gaussianize(y)
    fit <- geweke.smooth.log10spec(y)
    fit1 <- geweke.smooth.log10spec(log10spec.obs.lst=list(
                                      freqseq=fit$freqseq,
                                      log10spec.obs.unbiased=
                                      fit$log10spec.obs.unbiased))
    plot(fit$freqseq, fit$log10spec.obs.unbiased)
    lines(fit$freqseq, fit$log10spec.fitted, col=2)
    lines(fit1$freqseq, fit1$log10spec.fitted, col=3)
  }

  if(!missing(x)) {nx <- length(x)} else nx <- NA   
  ##prepare the raw log periodogram estimate, and correct the bias.
  if(missing(log10spec.obs.lst)){
    if(!missing(x)) {
      m <- 5
      spec <- smooth.spec(x, smooth.m = m, 
			  spec.pgram.arg = spec.pgram.arg)
      nu <- spec$df/2
      ## df: chisq df, nu: equivalent shape parameter for gamma
      bias <- (digamma(nu) - log(nu))/log(10)
      log10spec.obs.lst <- list(freqseq = spec$freq, 
				log10spec.obs.unbiased = log10(spec$spec)-bias)
    } else {stop("missing either x or log10spec.obs.lst")}
  }

  ##compute the non-parameteric fit, and make prediction at 
  ##a new set of frequencies
  x <- log10spec.obs.lst$freqseq
  freqseq <- c(min(c(1e-5, x/2)), x, 0.5) #add boundary values
  log10spec.obs.unbiased <- c(0, log10spec.obs.lst$log10spec.obs.unbiased, 0)
  loggeweke.sp <- log10(geweke.spec(freqseq))
  weights <- c(1e-6,rep(1,length(x)),1e-6)
  lo.fit <- loess(log10spec.obs.unbiased ~ loggeweke.sp, 
		  span = loess.arg$span, degree = loess.arg$degree, 
		  family = loess.arg$family, trace.hat=loess.arg$trace.hat,
		  weights=weights)
  out _ initialList(c("freqseq", "log10spec.obs.unbiased",
                      "log10spec.fitted",
                      "freqseq.pred",
                      "log10spec.pred",
                      "etp.fit", "n"))
  out _ updateList(out, list(freqseq=log10spec.obs.lst$freqseq,
                             log10spec.obs.unbiased=log10spec.obs.lst$log10spec.obs.unbiased,
                             n=nx))
  
  if(!is.null(lo.fit)) {
    log10spec.fitted <- lo.fit$fitted[-c(1,length(x)+2)]
    ## prediction
    freqseq.pred <- seq(0,0.5,len=500+1)[-1] ## freqseq for prediction
    sp.pred <- predict.loess(lo.fit, 
                             newdata=log10(geweke.spec(freqseq.pred)))
    ## entropy
    etp.fit <- entropy(freq=log10spec.obs.lst$freqseq,
                       spec=10^log10spec.fitted)
    twostep.pred.err.fit <- 
      drop.names(nstep.predict.err(freq=log10spec.obs.lst$freqseq,
				       spec=10^log10spec.fitted)["twostep"])
    out _ updateList(out, list(log10spec.fitted=log10spec.fitted,
                               freqseq.pred=freqseq.pred,
                               log10spec.pred=sp.pred,
                               etp.fit=etp.fit,
			       twostep.pred.err.fit=twostep.pred.err.fit
			       ))
  } else {
    out _ updateList(out, list(log10spec.fitted=NA,
                               freqseq.pred=NA,
                               log10spec.pred=NA,
                               etp.fit=NA,
			       twostep.pred.err.fit=NA
			       ))
  }
  out
}










