
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

"RTT.header" <- 
c("flowid", "ip0", "port0", "ip1", "port1", "SYN0ACKtime", "SYN0", 
        "SYN1ACKtime", "SYN1")

"dag.header" <- 
c("time", "len", "smac", "dmac", "ipproto", "sip", "dip", "sport", "dport")

"flow.header" <- 
c("flowid", "ip0", "port0", "ip1", "port1", "start", "dur", "type", "nPac0", "nPac1",
  "fsize0", "fsize1", "tsize0", "tsize1", "mss0", "mss1", "CFF")

"flow.header" <- 
c("flowid", "ip0", "port0", "ip1", "port1", "start", "dur", "type", "nPac0", "nPac1",
  "fsize0", "fsize1", "tsize0", "tsize1", "mss0", "mss1", 
  "SYN0ACKtime", "SYN1ACKtime", "serverDelay")

"flowIO.header" <- 
c("flowid", "ip0", "port0", "ip1", "port1", "start", "dur", "type", "nPac0", "nPac1",
  "fsize0", "fsize1", "tsize0", "tsize1", "mss0", "mss1", "CFF", "io")

"flowM.header" <- 
c("ip0", "port0", "ip1", "port1", "start", "dur", "type", "nPac0", "nPac1",
        "fsize0", "fsize1", "tsize0", "tsize1", "nGap0", "nGap1", "gapsize0",
        "gapsize1", "retran0", "retran1", "mss0", "mss1", "CFF", "block", 
        "firstPacIndx", "lastPacIndx")

"pactl.header" <- 
c("time", "len")

"pactls.header" <- 
c("time", "len", "smac")

tcppac.header _ 
c("time", "ip0", "port0", "ip1", "port1", "dir", "flag", "seq", "len", "ack",
        "win", "mss")
tcppacS.header _ tcppac.header
tcppacS2.header _ 
c("time", "ip0", "port0", "ip1", "port1", "dir", "flag", "seq", "len", "ack",
        "win", "mss", "flowid")
  
"tcppacF.header" <- 
c("time", "ip0", "port0", "ip1", "port1", "dir", "flag", "seq", "len", "ack",
        "win", "mss", "flowid")

"tcppacIO.header" <- 
c("time", "ip0", "port0", "ip1", "port1", "dir", "flag", "seq", "len", "ack",
        "win", "mss", "io")

"subflow.header" <- 
c("flowid", "subflowid", "ip0", "port0", "ip1", "port1", "start", "delay", "dur",
  "gap", "nPac0", "nPac1", "fsize0", "fsize1", "tsize0", "tsize1")

"tcppacS.subflowid.header" <- c("flowid", "subflowid")

"tcppacF2.header" <- 
c("time", "ip0", "port0", "ip1", "port1", "dir", "flag", "seq", "len", "ack",
        "win", "mss", "flowid","subflowid")

"thruput5.header" <-
c("proto","ip0","port0","ip1","port1","start","dur","total","maxia","rtp.p05","maxtp.n10","mintp.n10","medtp.n10","midmtp.n10","meantp")
"thruput7.header" <-
c("intf","proto","ip0","port0","ip1","port1","dir","start","dur","total","maxia","rtp.p05","maxtp.n10","mintp.n10","medtp.n10","midmtp.n10","meantp")

"ippac.header" <-
c("time","intf","proto","ip0","port0","ip1","port1","dir","iplen","ipid","fragoff","flag","seq","len","ack","win","mss","icmptype","icmpcode")

