
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

##
## interface to the jobqueue.pl program
##
## Make sure /n/data/packet/bin/jobqueue.pl is available
## 
dropTask _ function(task, server) {
  task _ paste("R_", task, sep="") ## to distinguish from the S version tasks
  mysystem(paste("jobqueue.pl -dropTask -task ", task, "-server ", server))
}
initTask _ function(task, jobids, server) {
  task _ paste("R_", task, sep="") ## to distinguish from the S version tasks
  mysystem(paste("jobqueue.pl -initTask -task ", task, "-server ", server), jobids)
}
getNextJob _ function(task, server) {
  task _ paste("R_", task, sep="") ## to distinguish from the S version tasks
  mysystem(paste("jobqueue.pl -getNextJob -task ", task, "-server ", server))
}
getJobCount _ function(task, server) {
  task _ paste("R_", task, sep="") ## to distinguish from the S version tasks
  mysystem(paste("jobqueue.pl -getJobCount -task ", task, "-server ", server))
}
updateJob _ function(task, jobid,
                     status="running", server) {
  task _ paste("R_", task, sep="") ## to distinguish from the S version tasks
  cmd _ paste("jobqueue.pl -updateJob -task ", task, "-server ", server,
              " -jobid ", jobid,
              " -status ", status)
  mysystem(cmd)
}
