
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## list2list _ function(lst) {
##   ## harvest list components from separate objects
##   nms _ unlist(find.objects(pattern=paste("^", lst, "[.]", sep="")))
##   newlst _ list()
##   for(nm in nms) {
##     cat(">>>", nm, "\n")
##     newlst[[nm]] _ get(nm, inherit=T)
##   }
##   newlst
## }

## list.to.data.frame _
list2df _
function(lst, keep.rownames=NULL, keep.listnames=NULL, sepObj=F) {
  ##
  ## simply rbind() data.frame's from a list
  ## assume each element in the list is a data.frame, and of the same dim
  ## Options:
  ## keep.rownames:  NULL or string for a new variable
  ##                 keeping the rownames of the original data.frames
  ## keep.listnames: NULL or string for a new variable
  ##                 keeping the components names of the original list
  ## 

  if(F) {
    x _ list(L1=data.frame(a=1, b=2, c="A"),
             L2=data.frame(a=3, b=4, c="C"))
    list2df(x)
    
    ## addtolist("myLst", data.frame(a=1, b=2, c="A"), "1st")
    ## addtolist("myLst", data.frame(a=3, b=4, c="C"), "2nd")
    ## list2df(myLst)
    ## list2df("myLst")
    ## 
    ## addtolist("myLst", data.frame(a=1, b=2, c="A"), "1st", sepObj=T)
    ## addtolist("myLst", data.frame(a=3, b=4, c="C"), "2nd", sepObj=T)
    ## list2df("myLst", sepObj=T)
    ## list2list("myLst")
  }

  df _ NULL
  if(!sepObj) {
    if(is.character(lst)) lst _ get(lst, inherit=T)
    nms _ names(lst)
  } else {
    if(!is.character(lst))
      stop("lst must be a character string when using sepObj option")
    nms _ unlist(find.objects(pattern=paste("^", lst, "[.]", sep="")))
  }
  
  for(nm in nms) { 
    cat(">>>", nm, "\n")
    if(!sepObj) {
      df0 _ lst[[nm]]
    } else {
      df0 _ get(nm, inherit=T)
    }
    
    if(!is.data.frame(df0)) {
      df0 _ data.frame(rbind(df0))
    }
    if(!is.null(keep.rownames)) {
      df0[,paste(keep.rownames)] _ dimnames(lst[[nm]])[[1]]
    }
    if(!is.null(keep.listnames)) {
      df0[,paste(keep.listnames)] _ rep(nm, nrow(df0))
    }
    if(!is.null(df)) df _ rbind(df, df0) else df _ df0
    cat(">>> dim(df)", dim(df), "\n")
  }
  cat(">>> dim(df)", dim(df), "\n")
  ## reset row names
  dimnames(df)[[1]] _ seq(nrow(df))
  df
}

if(F) {
  df _ NULL
  ## df0 _ data.frame(x="A", y=12.3)
  df0 _ data.frame(x=I("A"), y=12.3)
  sapply(df0, data.class)
  if(!is.null(df)) df _ rbind(df, df0) else df _ df0
  sapply(df, data.class)
}
