
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

model.spec <- function(para=list(varRatio=0.8, d=0.3, sigma.lSq=1),
		       freq=seq(0,0.5,len=1+floor(N/2)), N=100)
{
  ## $Id: model.R,v 1.1 2002/01/16 22:40:59 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/model.R,v $
  ##spectrum of the 3 parameter time-series model 
  ##(sqrt(1-a)*X(t) + sqrt(a)*N(t)), where X(t) is a 
  ##farima(d=d,ar=0,ma=1) process, and N(t) is the white noise.
  if(F) {
    x <- arima.fracdiff.sim(model=list(d=0.25), n=1000)
    fit <- fit.log10spec(x, init=list(varRatio=0.5,d=0.1,sigma.lSq=1))
    lst <- model.spec(para=fit$para, freq=fit$freqseq)
    plot(fit$freqseq, log10(lst$spec))
    points(fit$freqseq, fit$log10spec.fitted, col=2)

    lst <- model.spec(para=list(d=0.25, varRatio=0.5), N=1000)
    plot(lst$freq, lst$spec)
  }
  ##browser()
  get.var.farima.0.d.1 <- function(d)
    {
      ## variance of farima model(d,0,1)
      ## var.farima.0.d.1(.25) - 3.147575
      ## var.farima.0.d.1(.49) - 64.15799
      val <- ((2 + (2 * d)/(1 - d)) * gamma(1 - 2 * d))/
	((gamma(1 - d))^2)
      return(val)
    }
  if(!is.list(para)){
    nmes <- names(para)
    newpara <- initialList(nmes)
    for(i in nmes) newpara[[i]] <- para[i]
    para <- newpara
  }
  para <- updateList(list(varRatio=0.8, d=0.3, sigma.lSq=1),
		     para) #need at least two values, varRatio, d
  varRatio <- para[[1]]
  d <- para[[2]]
  sigma.lSq <- para[[3]]

  ##ARIMA(0,d,1) with variance 1
  ## Cd _ (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
  Cd <- get("get.var.farima.0.d.1", inherit = T)(d)
  spec <- (4*cos(pi*freq)^2)/(4*sin(pi*freq)^2)^d/Cd
  spec <- ((1-varRatio)*spec + varRatio)*sigma.lSq
  
  list(freq=freq, spec=spec)
}

nstep.predict.err <- function(freq=seq(0,0.5,by=0.1),
			      spec=rep(1,length(freq)))
{
  ##compute the 1-step and 2-step  prediction error of a stochastic process
  ##lst: of two components, freq and spec
  ##     freq must be ordered
  ##check Jin's project 2 notebook page 206 for the calculation 
  if(F) {
    lst <- model.spec(para=list(d=0.25, varRatio=0), N=1e5)
    e <- nstep.predict.err(lst$freq, lst$spec)
    lst <- model.spec(para=list(d=0.25, varRatio=0), freq=c(-0.1,0.2,0.5))
    e <- nstep.predict.err(lst$freq, lst$spec) #should dump the execution

    ##white noise and 1-order moving average process,
    ##nstep.predict.err should be close to 1
    ##dependent process, farima.0.d.1 process
    x <- rnorm(100000)  #case 1
    x <- arima.sim(model=list(ma=-1), n=10000); x <- x/sqrt(2) #case 2
    d <- 0.25; x <- arima.fracdiff.sim(model=list(d=d, ma=-1), n=30001)
    vx <- (2+2*d/(1-d))*gamma(1-2*d)/((gamma(1-d))^2)
    x <- x/sqrt(vx)  #case 3

    sp <- spec.pgram(x, spans=1, taper=0, pad=0, detrend=F, demean=F,plot=F)
    ##the problem here is that spec.pgram is not unbiased
    bias <- (digamma(1) - log(1))
    e <-  nstep.predict.err(freq=sp$freq, spec=10^(sp$spec/10))*exp(-bias)
    sp <- smooth.spec(x, smooth.m=5)  
    bias <- (digamma(5) - log(5))
    e <- nstep.predict.err(freq=sp$freq, spec=sp$spec)*exp(-bias)

    fit <- fit.log10spec.unbiased(x, init=list(varRatio=0.5,d=0.1,sigma.lSq=1))
    fit2 _ geweke.smooth.log10spec(log10spec.obs.lst=fit)
    e <- nstep.predict.err(freq=fit$freqseq, spec=10^fit$log10spec.obs)
    fit <- fit.log10spec(x, init=list(varRatio=0.5,d=0.1,sigma.lSq=1))
    e <- nstep.predict.err(freq=fit$freqseq, spec=10^fit$log10spec.obs)*
      exp(-(digamma(5) - log(5)))
    ##from this we see fit from fit.log10spec is biased
    e <- nstep.predict.err.model(para=c(varRatio=0,d=d))
  }
  ##browser()
  ##check the range of freq
  ran <- range(freq)
  if(ran[1] < 0 || ran[2] > 0.5) stop("check the range of freq\n")
  ##make the range be [0, 0.5]
  if(ran[1] > 0) {
    freq <- c(0, freq)
    spec <- c(spec[1], spec)
  }
  if(ran[2] < 0.5) {
    freq <- c(freq, 0.5)
    spec <- c(spec, spec[length(spec)])
  }
  if(min(diff(freq))<0) { ##make sure the frequency are ordered
    cat("sorting freq to an increasing order\n")
    ord <- order(freq)  
    freq <- freq[ord]; spec <- spec[ord]
  }
  if(min(spec, na.rm=T)<=0) {cat("check! some spec <= 0 !\n"); return()}
  ##compute the nstep.predict.err
  dfreq <- diff(freq)
  e <- exp(2*sum(log(spec)[-1]*dfreq)) ##entropy
  e1 <- 2*sum((log(spec)*cos(2*pi*freq))[-1]*dfreq) #1st coef. of ceptrum
  cat("prediction error: 1-step=", round(e,digit=3),
      ", 2-step=", round(e*(1+e1^2),digit=3), "\n")
  c(onestep=e, twostep=e*(1+e1^2))
}

nstep.predict.err.series <- function(x)
{
  ##compute the nstep.predict.err of a stochastic process x
  if(F) {
    #white noise, nstep.predict.err should be close to 1
    x <- rnorm(100000)
    e <-  nstep.predict.err.series(x)
  }
  ##browser()
  ##check the range of freq
  sp <- spec.pgram(x, spans=1, taper=0, pad=0, detrend=F, demean=F,plot=F)
  bias <- (digamma(1) - log(1))
  e <- nstep.predict.err(freq=sp$freq, spec=10^(sp$spec/10))*exp(-bias)
  e
}

nstep.predict.err.model <- 
  function(para=list(varRatio=0.8, d=0.3, sigma.lSq=1), N=1e5)
{
  ##nstep.predict.err for the 3 parameter model
  if(F) { 
    e <- nstep.predict.err.model(para=list(d=0.25, varRatio=0.5)) 
    e <- nstep.predict.err.model(para=list(d=0.25, varRatio=0.5), N=1e4) 
    e <- nstep.predict.err.model(para=list(d=0.25, varRatio=0))
  }
  ##browser()
  lst <- model.spec(para, N=N)
  ##if(is.list(para)) d <- para$d else d <- para["d"]
  ##spec0 <- 1/(4*sin(pi*lst$freq)^2)^d
  ##nstep.predict.err(lst$freq, lst$spec/spec0)
  nstep.predict.err(lst$freq, lst$spec)
}

entropy <- function(freq=seq(0,0.5,by=0.1), spec=rep(1,length(freq)))
{
  if(F){
    lst <- model.spec(para=list(d=0.25, varRatio=0), N=1e5)
    e <- entropy(lst$freq, lst$spec)
  }
  drop.names(nstep.predict.err(freq, spec)["onestep"])
}

entropy.series <- function(x)
{
  if(F){
    x <- rnorm(10000)
    entropy.series(x)
  }
  drop.names(nstep.predict.err.series(x)["onestep"])
}

entropy.model <-  function(para,...)
{
  if(F){
    e <- entropy.model(para=list(d=0.25, varRatio=0.5)) 
  }
  drop.names(nstep.predict.err.model(para,...)["onestep"])
}

