
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

movingMean <- function(x, s, wrap.around=F) {
  ##
  ## $Id: movingMean.R,v 1.1 2002/01/16 22:40:59 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/movingMean.R,v $
  ##
  if(F) {
    y <- 1:10; x _ seq(length(y))
    y <- rnorm(100); x _ seq(length(y))
    xm _movingMean(x, s=2)
    ym <- movingMean(y, s=2)
    plot(x, y)
    lines(xm, ym, col="red")
    xm _movingMean(x, s=5)
    ym <- movingMean(y, s=5)
    lines(xm, ym, col="blue")
  }

  ## browser()
  if(length(x)<s) {cat("s is too small! \n"); break}
  if(wrap.around){
    n1 <- floor((s+1)/2)-1
    n2 <- floor(s/2)
    if(n2>0){
      if(n1>0) x <- c(rev(rev(x)[1:n1]), x, x[1:n2]) 
      else x <- c(x,x[1:n2])
    }
  }
  cx <- cumsum(c(0,x))
  (cx[((s+1):length(cx))]-cx[(1:(length(cx)-s))])/s
}
