
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## $Id: myxyplot.R,v 1.3 2002/03/21 07:02:17 dxsun Exp $

panel.myxyplot <- function(x, y, ...){
  ## panel.xyplot(x, y, pch=".", col=1, cex=1.5, ...)
  out _ reduce.plot.points(x, y, do.sort=T); x _ out$x; y _ out$y
  panel.xyplot(x, y, pch=SNet.settings$pch, col=1, ...)
}

myxyplot _ function(x, y, cond, label=list(), psfile="", append=F, ...) {
  ##
  ## Generic xyplot used by time.plot, log2.time.plot etc.
  ##
  ## For example:
  ## x: time (such as flow start time)
  ## y: value at the time (such as file size)
  ##    such as packet InterArrival vs time
  ##            file size vs connection time 
  ## label: list(main="", sub="", xlab="", ylab="")
  ## psfile: if "", use current device, otherwise write to ps file
  ## append: append to ps file or create a new one
  ## ...: extra parameters pass to  trellis function
  ## 
  if(F) {
    fsize _ runif(10000); time _ seq(length(fsize))
    case <- rep(c("A","B","C","D"),length(time)/4)
    myxyplot(time, fsize)
    myxyplot(time, fsize, label=list(main=list(label="Main")))
    myxyplot(time, fsize, cond=case, layout=c(2,1))
    myxyplot(time, fsize, psfile="demo.ps")
    myxyplot(time, fsize, cond=case, layout=c(2,1), psfile="demo.ps")
    fsize _ runif(10000);
    myxyplot(time, fsize, psfile="demo.ps", append=T)
    myxyplot(time, fsize, psfile="demo.ps", append=T)
  }
  if(!missing(cond)) formu <- formula(y~x|cond) else formu <- formula(y~x)
  
  plt _ xyplot(formu, panel=panel.myxyplot, ...)
  plt _ update.plot.labels(plt,
                           xlab=deparse(substitute(x)),
                           ylab=deparse(substitute(y)),
                           label=label)
  
  if(psfile!="") {
    trellis.device("postscript", color = T, file = psfile, append=append,
                   paper="letter", bg = "white", first=T)
    print(plt)
    dev.off()
  } 
  plt
}
