
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

normal.qqplot _ function(y,
                         label=list(),
                         psfile="",
                         append=F,
                         horizontal=F,
			    ...) {
  ##
  ## $Id: normal.qqplot.R,v 1.3 2002/03/21 07:02:17 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/normal.qqplot.R,v $
  ##
  
  if(F) {
    y _ rnorm(1000)
    normal.qqplot(y)
    subStr _ paste("normal quantile plot")
    normal.qqplot(y, label=list(sub=subStr))
    normal.qqplot(y, label=list(sub=subStr), psfile="demo.ps")
  }

  ##browser()
  y _ sort(y)
  plt _ qqmath2(~y, dist=qnorm,
               ## aspect=0.75,
               panel=panel.qqnorm)
  plt _ update.plot.labels(plt,
                           xlab = "qnorm",
                           ylab = "x",
                           main = "Normal Quantile Plot",
                           label=label)

  if(psfile!="") {
    trellis.device("postscript", color = T, file = psfile, 
                   horizontal=horizontal, append=append,
                   paper="letter",bg = "white", first=T)
    print(plt)
    dev.off()
  } 
  plt

}

log2normal.qqplot _ function(y,
			    label=list(),
			    psfile="",
			    append=F,
			    ...) {
  if(F){
    y _ 2^{rnorm(1000)}
    log2normal.qqplot(y)
    subStr _ paste("log-normal quantile plot")
    log2normal.qqplot(y, label=list(sub=subStr))
    log2normal.qqplot(y, label=list(sub=subStr), psfile="demo.ps")
  }

  if(is.null(label$ylab)) label$ylab <- "log2(x)"
  if(is.null(label$main)) label$main <- "Log Normal Quantile Plot"
  normal.qqplot(log2(y), label, psfile, append, ...)
}

panel.qqnorm <- function(x, y){
  ## y is already log2(y)
  ## vertical lines
  panel.abline(v = quantile(x, 0.25 * c(1,3)), col = 1)
  panel.abline(v = quantile(x, c(0.1, 0.9)), col = 1)
  panel.abline(v = quantile(x, c(0.05, 0.95)), col = 1)
  ##horizontal lines
  ##abline(h = quantile(y, 0.25 * c(1:3)), col = 2)
  ##abline(h = quantile(y, c(0.1, 0.9)), col = 3, lty = 2)
  ##abline(h = quantile(y, c(0.05, 0.95)), col = 4, lty = 3)

  ## inter-quartile
  slope <- sqrt(var(y))
  intercept <- mean(y)
  panel.abline(intercept, slope, col = 6)
  ## qqplot
  ## panel.qqmath(x, y, col = 1, cex = 1.5, pch = ".")
  panel.qqmath(x, y, col = "black", pch = SNet.settings$pch)
}




