
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## osave: object save
## osave: object get

ols _ function(pattern="*") {
  ## object listing
  ## if(missing(where)) {
  ##   where _ ".RDir"
  ## }
  dir.stack <- pwd()
  lst _ list()
  for (dir in dir.stack) {
    where _ paste(dir, ".RDir", sep="/"); 
    if(file.exists(where)) {
      out _ system(paste("cd ", where, "; ls ", pattern), intern=TRUE)
      if(length(out)>0)  lst[[where]] _ out
    }
  }
  lst
}

osave _ function(name, obj, where, compress=T) {
  ## object save to separate disk file in .RDir directory
  if(F) {
    x _ 1:10
    osave("y", x)
    oget("y")
  }
  if(missing(where)) {
    if(!file.exists(".RDir")) {
      cat(">>> creating directory .RDir\n")
      system(paste("mkdir -p .RDir"))
    }
    where _ ".RDir"
  } 
  fn _ paste(where, name, sep="/")
  if(missing(obj)) assign(name, get(name)) else assign(name, obj)
  save(list=name, file=fn, compress=compress)
  cat(">>> saving ", name, " to ", fn, "\n", sep="")
}

oget _ function(name) {
  ## object get from .RDir directory
  if(F) {
    myobj _ oget("myobj1")
    myobj _ oget("newObj")
  }
  if(exists(name)) return(get(name))
  dir.stack <- pwd()
  for (dir in dir.stack) {
    fn _ paste(dir, ".RDir", name, sep="/")
    if(file.exists(fn)) {
      cat(">>> loading ", name, " from ", fn, "\n", sep="")
      load(fn)
      return(get(name))
    }
  }
  cat(">>> ", name, " not found\n", sep="")
  return(NULL)
}

omv _ orename _ function(src, dst) {
  ## in R, renaming the saved object doesn't change the object name
  ##   so we need to read it, and save as a different name
  obj _ oget(src)
  osave(dst, obj)
  orm(src)
}

orm _ oremove _ function(name) {
  ## object get from .RDir directory
  if(F) {
    orm("myobj1")
  }
  if(exists(name)) {
    rm(name)
    return(NULL)
  }
  dir.stack <- pwd()
  for (dir in dir.stack) {
    fn _ paste(dir, ".RDir", name, sep="/")
    if(file.exists(fn)) {
      cat(">>> removing ", name, " from ", fn, "\n", sep="")
      ## load(fn)
      unlink(fn)
      return(NULL)
      ## return(get(name))
    }
  }
  cat(">>> ", name, " no found\n", sep="")
  return(NULL)
}


