
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

pareto.qqplot _ function(y, label=list(), psfile="", append=F,
                         horizontal=F, ...) {
  ##
  ## $Id: pareto.qqplot.R,v 1.3 2002/03/21 07:02:17 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/pareto.qqplot.R,v $
  
  if(F) {
    y _ exp(rexp(1000)^{1.5})
    pareto.qqplot(y)
    subStr _ paste("pareto qqplot")
    pareto.qqplot(y, label=list(sub=subStr))
    pareto.qqplot(y, label=list(sub=subStr), psfile="demo.ps")
  }

  y _ sort(y)
  
  mypanel <- function(x,y){ ## y is already log2(y)
    ## browser()
    ## horizontal lines
    panel.abline(v = quantile(x, 0.25 * c(1,3)), col = 1)
    panel.abline(v = quantile(x, c(0.1, 0.9)), col = 1)
    panel.abline(v = quantile(x, c(0.05, 0.95)), col = 1)
    ## inter-quartile
    y0 <- quantile(y, c(0.25, 0.75))
    x0 <- quantile(x, c(0.25, 0.75))
    if(x0[2]!=x0[1]){
      slope <- (y0[2] - y0[1])/(x0[2] - x0[1])
      intercept <- y0[2] - x0[2] * slope
      panel.abline(intercept, slope, col = 6)
    } else {slope <- NA; intercept <- NA}
    cat("slope=",round(slope,3),"2^intercept=", 
	round(2^intercept,6), "\n")
    str <- paste("slope=",round(slope,3),"2^intcpt=", 
		 round(2^intercept,3))
    ltext(min(x)+3, max(y)-0.2, str, cex=0.75)
    ## exponential
    panel.abline(log2(mean(2^(y))), 1, col = 8) ## shape =1 , scale = mean(2^(log2(y)))
    ## qqplot
    panel.qqmath(x,y,col=1,cex=1.5,pch=".") 
  }
  
  plt _ qqmath2(~log2(log(y)), dist=function(p) log2(qexp(p)), panel=mypanel)
  plt _ update.plot.labels(plt,
                           xlab = "log2(qexp(p))",
                           ylab = "log2(log(x))",
                           main = "Pareto Quantile Plot",
                           label=label)
  plt$main$cex _ plt$sub$cex _ 0.8

  if(psfile!="") {
    trellis.device("postscript", color = T, file = psfile,
                   horizontal=horizontal, append=append,
                   paper="letter", bg = "white", first=T)
    print(plt)
    dev.off()
  } 
  plt
}

## rDiscretePareto <- function(n, k, alpha){
##   ##generate random samples
##   if(F) {
##     rDiscretePareto(n, k, alpha)
##   }
##   ceiling(rpareto(n, k, alpha))
## }
## 
## ##I am still testing this code
## discretePareto.qqplot <- function(y,
##                                   label=list(),
##                                   psfile="",
##                                   append=F,
##                                   estimate=list(),
##                                   ...) 
## {
##   if(F) {
##     y _ rDiscretePareto(1000, k=1, alpha=1.5)
##     y _ rDiscreteWeibull(1000, shape=0.5, scale=1)
##     para _ fitDiscretePareto.tailprob.ls(y)
##     discretePareto.qqplot(y)
##     discretePareto.qqplot(y, estimate=para)
##     discretePareto.qqplot(y, label=list(sub=subStr), psfile="demo.ps")
##   }
## 
##   ##browser()
##   mypanel <- function(x,y){ 
##     ##browser()
##     ## horizontal lines
##     abline(v = -log2(c(0.25, 0.75)), col = 1)
##     abline(v = -log2(c(0.1, 0.9)), col = 1)
##     abline(v = -log2(c(0.05, 0.95)), col = 1)
## 
##     ## least squre fit estimate 
##     coef <- lsfit(x,y)$coef
##     abline(coef, col=6)
##     cat("tail index=",round(coef[2],3),",k=", round(2^{-coef[1]},3), "\n")
##     ## qqplot
##     panel.xyplot(x,y,col=1,cex=2,pch=".") 
##   }
## 
##   if(is.null(label$sub)) {
##     if(length(estimate)==0) {
##       para _ fitDiscretePareto.tailprob.ls(y); para$type <- "LS"
##     } else para _ estimate
##     label$sub _ paste(para$type, ":tail index=", round(para$alpha,2),
##                       ", minimum=", round(para$k,2), sep="")
##   }
## 
##   tp <- tailProb(y, discrete=T)
##   y <- log2(tp$x); 
##   x <- -log2(tp$tp); 
##   plt _ xyplot(y~x, panel=mypanel)
##   plt _ updateList(plt, list(xlab = "-log2(P(X>x))",
##                              ylab = "log2(x)",
##                              main = "DiscretePareto Quantile Plot"))
##   plt _ updateList(plt, label)
## 
##   if(any(names(plt)=="main")) plt$main _ list(label=plt$main, cex=0.8)
##   if(any(names(plt)=="sub")) plt$sub _ list(label=plt$sub, cex=0.8)
## 
##   if(psfile!="") {
##     trellis.device("postscript", color = T, file = psfile, append=append)
##     print(plt)
##     dev.off()
##   } 
##   plt
## }
## 
## fitDiscretePareto.tailprob.ls <- function(x){
##   ##fit paramters of DiscretePareto using tail prob.
##   if(F) {
##     x <- rDiscretePareto(5000, k=1, alpha=1.5)
##     out <-  fitDiscretePareto.tailprob.ls(x)
##   }
##   ##browser()
##   lst <- tailProb(x, discrete=T)
##   fit <- lsfit(log(lst$x), -log(lst$tp), wt=lst$p)
##   te <- fit$coef; names(te) <- NULL
##   list(alpha=te[2], k=exp(-te[1]))
## }
