
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

qlen _ function(intArriv, load) {
  ## 
  ## Input:
  ##   intArriv: inter-arrival time
  ##   load: is service time = packet byte/line speed
  ## 
  ## Output:
  ##   qlenN: queue length in no. of packets
  ##   qload0: queue length in bytes for partial packets
  ##   qload1: queue length in bytes for complete packets
  ## 
  ## Note: simulate the queue behaviour. It takes the interarrival time and
  ## load (=service time=packet byte/line speed) and return the queue 
  ## length in no. of packets (qlenN), queue length in bytes 
  ## for partial packets (qload0) and complete packets (qload1).
  ## intArriv[i] = interarrival time between (i+1)th and ith packet
  ##
  if(F) {
    attach("/packet/lib/SNetAnalysis")
    intArriv _ c(0.2,2.0,0.9,0.1,0.1,0.3,0.1,0.1,1.4,1.3)
    load _ c(0.4,0.6,0.4,0.6,0.4,0.6,0.4,0.6,0.4,0.6)
    ql _ qlen(intArriv, load)
    
  }
  n _ max(length(intArriv), length(load))
  out _ .C("qlen", as.double(intArriv),
           as.double(load),
           double(n),
           qlenN = integer(n),
           qload0 = double(n),
           qload1 = double(n),
           as.integer(n))
  out[names(out) != ""]
}
               
