
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

qlen0 _ function(intArriv, load) {
  ## intArriv: inter-arrival time
  ## load: is service time = packet byte/line speed
  if(F) {
    attach("/packet/lib/queue")
    intArriv _ c(0.2,2.0,0.9,0.1,0.1,0.3,0.1,0.1,1.4,1.3)
    load _ c(0.4,0.6,0.4,0.6,0.4,0.6,0.4,0.6,0.4,0.6)
    ql _ qlen0(intArriv, load)
  }
  n _ max(length(intArriv), length(load))
  out _ .C("qlen0", as.double(intArriv),
           as.double(load),
           qload0 = double(n),
           as.integer(n))
  out[names(out) != ""]
}
               
