
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

qlen0.finite.buffer _ function(intArriv, load, buffer) {
  ## intArriv: inter-arrival time, time to next arrival
  ## load: is service time = packet byte/line speed
  ## intArriv and load doesn't have to be the same length
  if(F) {
    tm _   c(0,  0.2, 2.2, 3.1, 3.2, 3.3, 3.6, 3.7, 3.8, 5.2)
    load _ c(0.4,0.6, 0.4, 0.6, 0.4, 0.6, 0.4, 0.6, 0.4, 0.6)
    intArriv _ diff(tm)
    ##intArriv _ c(0.2,2.0,0.9,0.1,0.1,0.3,0.1,0.1,1.4,1.3)
    buffer _ 0.9
    ql _ qlen0.finite.buffer(intArriv, load, buffer)
  }
  n _ min(length(intArriv)+1, length(load))
  out _ .C("qlen0_finite_buffer", 
	   as.double(intArriv),
           as.double(load),
	   as.double(buffer),
	   as.integer(n),
           qload0 = double(n),
           droprate = double(1))
  out[names(out) != ""]
}
               
