
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

read.flow _ function(filename="", type="", override=T, make.names=T) {
  ## 
  ## $Id: read.flow.R,v 1.3 2002/02/01 17:54:18 dxsun Exp $
  ##
  ## - read object from flat ascii file from disk (possibly gzipped)
  ##   with header information based on file type/suffix
  ## - when the file name ends with ".gz", it will be removed in forming the
  ##   ibject name
  ## - name of the function read.flow() comes from the function for read flow objects,
  ##   the name is kept for backward compatibility
  ##   
  ## type can be "flow", "RTT", tcppac etc.
  ## override=T: override the existing object if it is in the same directory
  ##
  if(F) {
    tmp _ read.flow("99_08_09.h05.flow.gz",
                    dir="/sde1/flowComp/Sun_Aug_8_06_00_01_1999")
    tmp _ read.flow("/sde1/flowComp/Sun_Aug_8_06_00_01_1999/99_08_09.h05.flow.gz")
    tmp _ read.flow("/sdf1/RTT/Sun_Aug_8_06_00_01_1999/99_08_09.h05.RTT.gz",
                    type="RTT")
  }

  for(prog in c("pushd","popd","pwd","getfile","zread.table")) {
    if(!exists(prog)) {
      stop("make sure these programs are available: pushd popd pwd getfile zread.table")
    }
  }

  if( is.null(filename _ getfile(filename)) ) {
    return(NULL)
  }
  objname _ sub("\.gz$", "", basename(filename))
  if(make.names) {
    objname _ make.names(paste(type, sub(paste(".", type, "$",sep=""),
                                         "", objname), sep="."))
  }

  if( (!exists(objname) && is.null(oget(objname))) || override) {
    ## 1. read object
    osave(objname, NULL)
    ## assign(objname, NULL, where=1) ## signal other R processes not to duplicate this run
    ## browser()
    ## obj _ zread.table(filename, header=F, sep=" ", row.names=NULL)
    obj _ zread.table(filename, header=F, sep=" ", row.names=NULL, as.is=T)
    print(dim(obj))
    if(exists(paste(type,".header",sep=""))) {
      col.names _ get(paste(type,".header",sep=""))
      if(ncol(obj)==length(col.names)) {
        names(obj) _ col.names
      } else {
        cat(">>> check \"", type, "\" file format\n", sep="")
        cat(">>> ncol(obj)=", ncol(obj),
            " differs from length(col.names)=", length(col.names), "\n", sep="")
        if(ncol(obj)>length(col.names)) {
          names(obj) _ c(col.names, names(obj)[(length(col.names)+1):ncol(obj)])
        } else {
          names(obj) _ col.names[seq(ncol(obj))]
        }
      }
      ## return(NULL)
    } else {
      cat(">>> warning: cannot find ", paste(type,".header",sep=""), "\n");
    }
    
    ## 2. save it on disk
    cat(">>> saving", objname, "\n")
    ## assign(objname, obj, where=1)
    osave(objname, obj)
  } else {
    cat(">>> ", objname, "exists, skip\n")
  }
  return(objname)
}
  
