
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

check.numeric _ function(strvec) {
  ##
  ## this function is merely to avoid
  ## NA warning message in using as.numeric
  ## 
  if(F) {
    strvec _ c("ABC", "123", "1.23", "e5", "12.3e3", "1.2.3.4")
    check.numeric(strvec)
  }
  out _ .C("check_numeric",
           as.character(strvec),
           as.integer(length(strvec)),
           flag = integer(length(strvec)))
  out$flag
}

reclass.data.frame _ function(dfm, nr=5) {
  ## 
  ## it is very annoying that characters and logicals are
  ## converted to factor automatically
  ##
  ## convert factor variables back to character
  ## nr: decide type based on the first nrow lines
  ##
  if(F) {
    dat _ data.frame(X=letters, Y=seq(length(letters)))
    dat$Z _ factor(sample(LETTERS))
    dat$A _ as.character(dat$Y)
    sapply(dat, data.class)
    dat _ reclass.data.frame(dat)
    sapply(dat, data.class)
  }
  
  if(nr<=0) nr _ nrow(dfm) else nr _ min(nr, nrow(dfm))
  for(nm in names(dfm)) {
    if(is.factor(dfm[[nm]])) {
      dfm[[nm]] _ as.character(dfm[[nm]])
      cat(">>> convert", nm, "from factor to character\n")
    }
    if(is.character(dfm[[nm]])) {
      ind _ dfm[[nm]] != "NA";
      if(sum(ind)>1) {
        if(all(check.numeric(dfm[[nm]][ind][1:(min(nr,sum(ind)))])==1)) {
          cat(">>> convert", nm, "from character to numeric\n")
          dfm[[nm]] _ as.numeric(dfm[[nm]])
        }
      }
    }
  }
  dfm
}
