
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##


## reduce consecutive graphically-indistinguishable points
reduce.plot.points _ function(x, y, thresh=2e-4, do.sort=F) {
  ##
  ## thresh: points are considered to be graphicallt indistinguishable
  ##  when their gap is smaller than thresh*diff(range())
  ##
  if(F) {
    set.seed(0)
    fsize _ abs(rnorm(100000)); time _ seq(length(fsize))
    fsize.srt _ sort(fsize)
    length(fsize)/length(unique(fsize))
    out _ reduce.plot.points(time, fsize.srt)

    ord _ sample(seq(length(time)))
    out _ reduce.plot.points(time[ord], fsize.srt[ord])
    out _ reduce.plot.points(time[ord], fsize.srt[ord], do.sort=T)
    tps(file="tmp1.ps")
    print(xyplot(fsize.srt ~ time, pch="."))
    dev.off()
    tps(file="tmp2.ps")
    print(xyplot(out$y ~ out$x, pch="."))
    dev.off()
    tps(file="tmp3.ps")
    plot(time, fsize.srt, pch=".")
    points(out$x, out$y, pch=".", col=3)
    dev.off()
  }

  if(exists("SNet.settings") &&
     !is.null(SNet.settings$reduce.plot.points.thresh)) {
    cat(">>> using SNet.settings$reduce.plot.points.thresh:",
        SNet.settings$reduce.plot.points.thresh, "\n")
    thresh _ SNet.settings$reduce.plot.points.thresh
  }
  if(thresh <= 0) {
    ## no need to reduce
    return(list(x=x, y=y))
  }

  thresh.x _ diff(range(x)) * thresh
  thresh.y _ diff(range(y)) * thresh
  
  if(do.sort) {
    ord _ order(x); x _ x[ord]; y _ y[ord]
    ord _ order(y); x _ x[ord]; y _ y[ord]
    n _ min(length(x), length(y))
    out _ .C("reduce_plot_points",
             x = as.double(x),
             y = as.double(y),
             as.integer(n),
             n = integer(1),
             as.double(thresh.x),
             as.double(thresh.y))
    cat(">>> points reduced from", n, "to", out$n, "\n")
    x _ out$x[1:out$n]
    y _ out$y[1:out$n]
    
    ord _ order(y); x _ x[ord]; y _ y[ord]
    ord _ order(x); x _ x[ord]; y _ y[ord]
    n _ min(length(x), length(y))
    out _ .C("reduce_plot_points",
             x = as.double(x),
             y = as.double(y),
             as.integer(n),
             n = integer(1),
             as.double(thresh.x),
             as.double(thresh.y))
    cat(">>> points reduced from", n, "to", out$n, "\n")
    x _ out$x[1:out$n]
    y _ out$y[1:out$n]
  } else {
    n _ min(length(x), length(y))
    out _ .C("reduce_plot_points",
             x = as.double(x),
             y = as.double(y),
             as.integer(n),
             n = integer(1),
             as.double(thresh.x),
             as.double(thresh.y))
    cat(">>> points reduced from", n, "to", out$n, "\n")
    x _ out$x[1:out$n]
    y _ out$y[1:out$n]
  }
  list(x=x, y=y)
}
                              
if(F) {
  ## find out what's the biggest difference between two numbers
  ##   that are indistinguishable on plots with pch="."

  tps(file="tmp_diff_points.ps")
  x _ y _ NULL
  for(n in round(10^((0:50)/10))) {
    x _ c(x, seq(0,1,len=n))
    y _ c(y, rep(log10(n), n))
  }
  print(xyplot(y ~ x, pch=".", col=1))
  dev.off()

}
