
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

run.intvl.flow.ia.marg _ function(obj, tag) {
  cat(">>> run.intvl.flow.ia.marg()\n")
  tag _ update.tag.runName(tag, "flow.ia.marg")
  if(nrow(obj)>SNet.settings$min.nrow){
    time _ obj$time - obj$time[1]
    ia _ InterArrival(time)
    tag$weibull.estimate _ weibull.estimate(ia, type="MLE")
    ## 1.
    log2.time.plot(time, ia,
                   label=list(main=tag$main,
                     ylab="Log2(Packet Inter Arrival Time)"),
                   psfile=paste(tag$psPrefix, "time.plot", tag$psSuffix, sep="."))
    ## 2.
    weibull.qqplot(ia, 
		   label=list(main=tag$main, 
		       ylab="Log2 Packet Inter Arrival Time"),
		   psfile=paste(tag$psPrefix, "weibull.qqplot", tag$psSuffix, sep="."),
		   estimate=tag$weibull.estimate)
    unif.qqplot(log2(ia), 
		label=list(main=tag$main, 
		    ylab="Log2 Packet Inter Arrival Time"),
		psfile=paste(tag$psPrefix, "unif.qqplot", tag$psSuffix, sep="."))

  }
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.ia.marg _ function(settings) {
  cat(">>> summary.intvl.flow.ia.marg()\n")
  vars <- c("shape","scale")
  template.summary.intvl(settings$runName, vars, settings)
}

run.intvl.flow.ia.spec _ function(obj, tag) {
  cat(">>> run.intvl.flow.ia.spec()\n")
  tag _ update.tag.runName(tag, "flow.ia.spec")
  if(nrow(obj)>SNet.settings$min.nrow) {
    time _ obj$time - obj$time[1]
    ia _ InterArrival(time)
    ia[ia<=0] <- rep(1e-6,sum(ia<=0)) ## zero inter-arrival time --> 1usec
    y.tr _ gaussianize(ia)   
    tag _ template.spec.fit(y.tr, tag)
  }
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.ia.spec _ function(settings) {
  cat(">>> summary.intvl.flow.ia.spec()\n")
  vars _ c("d","varRatio",
           "etp", "etp.fit","geweke.smooth.etp.fit",
           "twostep.pred.err", "twostep.pred.err.fit",
           "geweke.smooth.twostep.pred.err.fit")
  template.summary.intvl(settings$runName, vars, settings)
}

run.intvl.flow.dur.marg _ function(obj, tag) {
  cat(">>> run.intvl.flow.dur.marg()\n")
  tag _ update.tag.runName(tag, "flow.dur.marg")
  if(nrow(obj)>SNet.settings$min.nrow) {
    time _ obj$time - obj$time[1]
    y _ obj$dur
    id _ (!is.na(y) & (y>0))
    time _ time[id]; y _ y[id]
    ## time plot
    log2.time.plot(time, y, label=list(main=tag$main,
				ylab="Log2(Flow Duration)"),
		   psfile=paste(tag$psPrefix, "time.plot", tag$psSuffix, sep="."))
    ## marginal plot
    log2normal.qqplot(y, label=list(main=tag$main,
                           ylab="Log2(Flow Duration)"),
		      psfile=paste(tag$psPrefix, "log2normal.qqplot", tag$psSuffix, sep="."))
    tag$log2normal.estimate _ list(mean=mean(log2(y),), var=var(log2(y)))
    ## get samples
    tag$samp <- template.sample(y)
    ## assign result
  }
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.dur.marg _ function(settings) {
  cat(">>> summary.intvl.flow.dur.marg()\n")
  vars <- c("mean", "var")
  template.summary.intvl(settings$runName, vars, settings)
}

run.intvl.flow.dur.spec _ function(obj, tag) {
  cat(">>> run.intvl.flow.dur.spec()\n")
  tag _ update.tag.runName(tag, "flow.dur.spec")
  if(nrow(obj)>SNet.settings$min.nrow) {
    y.tr _ gaussianize(obj$dur)   
    tag _ template.spec.fit(y.tr, tag)
  }
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.dur.spec _ function(settings) {
  cat(">>> summary.intvl.flow.dur.spec()\n")
  vars _ c("d","varRatio",
           "etp", "etp.fit","geweke.smooth.etp.fit",
           "twostep.pred.err", "twostep.pred.err.fit",
           "geweke.smooth.twostep.pred.err.fit")
  template.summary.intvl(settings$runName, vars, settings)
}

run.intvl.flow.fsize0.marg _ function(obj, tag) {
  cat(">>> run.intvl.flow.fsize0.marg()\n")
  tag _ update.tag.runName(tag, "flow.fsize0.marg")
  if(nrow(obj)>SNet.settings$min.nrow) {
    time _ obj$time - obj$time[1]
    y _ obj$fsize0
    id _ (!is.na(y) & (y>0))
    time _ time[id]; y _ y[id]
    ## time plot
    log2.time.plot(time, y, label=list(main=tag$main,
                              ylab="Log2(Server File Size)"),
		   psfile=paste(tag$psPrefix, "time.plot", tag$psSuffix, sep="."))
    ## marginal plot
    pareto.qqplot(y, label=list(main=tag$main,
			 ylab="Log2(Server File Size)"),
		  psfile=paste(tag$psPrefix, "pareto.qqplot", tag$psSuffix, sep="."))
    tag$samp <- template.sample(y)

    ##
    ## fit run length
    is.download <- (y>275)
    tag$download.prob <- mean(is.download)
    runlen <- altRunlen(is.download, eqlen=T)
    if(min(sapply(runlen,length)) > 10) {
      tag$download.runlen.estimate <- sapply(runlen, fitDiscreteWeibull.MLE, simplify=F)
      vs <- c("runlen0", "runlen1"); labs <- c("Non-Download", "Download")
      for(i in 1:2) {
	v <- vs[i]; lab <- labs[i]
	discreteWeibull.qqplot(runlen[[v]], 
			       label=list(main=tag$main,
				   ylab=paste("Log2 Run Length", lab)),
			       psfile=paste(tag$psPrefix, "discreteWeibull.qqplot",
                                 v, lab, 
                                 tag$psSuffix, sep="."),
                               estimate=c(list(type="MLE"), tag$download.runlen.estimate[[v]]))
      }
    }
  }
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.fsize0.marg _ function(settings) {
  cat(">>> summary.intvl.flow.fsize0.marg()\n")
  vars <- c("download.prob", "runlen0.shape", "runlen0.scale",
            "runlen1.shape", "runlen1.scale")
  template.summary.intvl(settings$runName, vars, settings)
}

run.intvl.flow.fsize0.spec _ function(obj, tag) {
  cat(">>> run.intvl.flow.fsize0.spec()\n")
  tag _ update.tag.runName(tag, "flow.fsize0.spec")
  if(nrow(obj)>SNet.settings$min.nrow) {
    y <- obj$fsize0
    y.tr <- gaussianize(y)
    tag _ template.spec.fit(y.tr, tag)
  }  
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.fsize0.spec _ function(settings) {
  cat(">>> summary.intvl.flow.fsize0.spec()\n")
  vars _ c("d","varRatio",
           "etp", "etp.fit","geweke.smooth.etp.fit")
  template.summary.intvl(settings$runName, vars, settings)
}

run.intvl.flow.fsize1.marg _ function(obj, tag) {
  cat(">>> run.intvl.flow.fsize1.marg()\n")
  tag _ update.tag.runName(tag, "flow.fsize1.marg")
  if(nrow(obj)>SNet.settings$min.nrow) {
    y _ obj$fsize1
    id _ (!is.na(y) & (y>0))
    time _ obj$time - obj$time[1]
    time _ time[id]; y _ y[id]
    ## time plot
    log2.time.plot(time, y, label=list(main=tag$main,
				ylab="Log2 Client File Size (bytes)"),
		   psfile=paste(tag$psPrefix, "time.plot", tag$psSuffix, sep="."))
    ## marginal plot
    pareto.qqplot(y, label=list(main=tag$main,
			 ylab="Log2 Client File Size (bytes)"),
		  psfile=paste(tag$psPrefix, "pareto.qqplot", tag$psSuffix, sep="."))
    unif.qqplot(log2(y), label=list(main=tag$main,
			     ylab="Log2 Client File Size (bytes)"),
		psfile=paste(tag$psPrefix, "unif.qqplot", tag$psSuffix, sep="."))
    ## get samples
    tag$samp <- template.sample(y)
  }
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.fsize1.marg _ function(settings) {
  cat(">>> summary.intvl.flow.fsize1.marg()\n")
  ## nothing to summarize
}

run.intvl.flow.fsize1.spec _ function(obj, tag) {
  cat(">>> run.intvl.flow.fsize1.spec()\n")
  tag _ update.tag.runName(tag, "flow.fsize1.spec")
  if(nrow(obj)>SNet.settings$min.nrow) {
    y <- obj$fsize1
    y.tr <- gaussianize(y)
    tag _ template.spec.fit(y.tr, tag)
  }  
  include.assign.result(tag)
  tag$runName
}
summary.intvl.flow.fsize1.spec _ function(settings) {
  cat(">>> summary.intvl.flow.fsize1.spec()\n")
  vars _ c("d","varRatio",
           "etp", "etp.fit","geweke.smooth.etp.fit")
  template.summary.intvl(settings$runName, vars, settings)
}

## run.intvl.flow.rtt0.marg _ function(obj, tag) {
##   cat(">>> run.intvl.flow.rtt0.marg()\n")
##   tag _ update.tag.runName(tag, "flow.fsize1.marg")
##   if(nrow(obj)>SNet.settings$min.nrow) {
##     time _ obj$time - obj$time[1]
##     y _ obj$SYN1ACKtime
##     id _ (!is.na(y) & (y>0))
##     time _ time[id]; y _ y[id]
##     ## time plot
##     log2.time.plot(time, y, label=list(main=tag$main,
##                               ylab="Log2 Server-side Round Trip Time"),
##                    psfile=paste(tag$psPrefix, "time.plot", tag$psSuffix, sep="."))
##     ## marginal plot
##     weibull.qqplot(y, label=list(main=tag$main,
##                           ylab="Log2 Server-side Round Trip Time"),
##                    psfile=paste(tag$psPrefix, "weibull.qqplot",
##                      tag$psSuffix, sep="."))
##     ## get samples
##     tag$samp <- template.sample(y)
##   }
##   include.assign.result(tag)
##   tag$runName
## }
## summary.intvl.flow.rtt0.marg _ function(settings) {
##   cat(">>> summary.intvl.flow.rtt0.marg()\n")
##   ## nothing to summarize
## }
## 
## run.intvl.flow.rtt0.spec _ function(obj, tag) {
##   cat(">>> run.intvl.flow.rtt0.spec()\n")
##   tag _ update.tag.runName(tag, "flow.rtt0.spec")
##   if(nrow(obj)>SNet.settings$min.nrow) {
##     y <- obj$SYN1ACKtime
##     y.tr <- gaussianize(y)
##     tag _ template.spec.fit(y.tr, tag)
##   }  
##   include.assign.result(tag)
##   tag$runName
## }
## summary.intvl.flow.rtt0.spec _ function(settings) {
##   cat(">>> summary.intvl.flow.rtt0.spec()\n")
##   vars _ c("d","varRatio",
##            "etp", "etp.fit","geweke.smooth.etp.fit")
##   template.summary.intvl(settings$runName, vars, settings)
## }
## 
## run.intvl.flow.rtt1.marg _ function(obj, tag) {
##   cat(">>> run.intvl.flow.rtt1.marg()\n")
##   tag _ update.tag.runName(tag, "flow.fsize1.marg")
##   if(nrow(obj)>SNet.settings$min.nrow) {
##     time _ obj$time - obj$time[1]
##     y _ obj$SYN0ACKtime
##     id _ (!is.na(y) & (y>0))
##     time _ time[id]; y _ y[id]
##     ## time plot
##     log2.time.plot(time, y, label=list(main=tag$main,
##                               ylab="Log2 Client-side Round Trip Time"),
##                    psfile=paste(tag$psPrefix, "time.plot", tag$psSuffix, sep="."))
##     ## marginal plot
##     weibull.qqplot(y, label=list(main=tag$main,
##                           ylab="Log2 Client-side Round Trip Time"),
##                    psfile=paste(tag$psPrefix, "weibull.qqplot",
##                      tag$psSuffix, sep="."))
##     ## get samples
##     tag$samp <- template.sample(y)
##   }
##   include.assign.result(tag)
##   tag$runName
## }
## summary.intvl.flow.rtt1.marg _ function(settings) {
##   cat(">>> summary.intvl.flow.rtt1.marg()\n")
##   ## nothing to summarize
## }
## 
## run.intvl.flow.rtt1.spec _ function(obj, tag) {
##   cat(">>> run.intvl.flow.rtt1.spec()\n")
##   tag _ update.tag.runName(tag, "flow.rtt1.spec")
##   if(nrow(obj)>SNet.settings$min.nrow) {
##     y <- obj$SYN0ACKtime
##     y.tr <- gaussianize(y)
##     tag _ template.spec.fit(y.tr, tag)
##   }  
##   include.assign.result(tag)
##   tag$runName
## }
## summary.intvl.flow.rtt1.spec _ function(settings) {
##   cat(">>> summary.intvl.flow.rtt1.spec()\n")
##   vars _ c("d","varRatio",
##            "etp", "etp.fit","geweke.smooth.etp.fit")
##   template.summary.intvl(settings$runName, vars, settings)
## }

