
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##


run.intvl.task _ function(settings) {
  if(F) {
    ## TESTING case

    ## pac.ia.transform = "std.pow" ## 1/6 power, run.intvl.pac.ia.spec.powertrans
    ## pac.ia.transform = "std.log" ## run.intvl.pac.ia.spec.notrans
    ## pac.ia.transform = "gaus" ## gaussinize, run.intvl.pac.ia.spec

    ## pac.cnt.transform = "std.log"
    ## pac.cnt.transform = "gaus"
    ## pac.cnt.transform = "std"
    
    settings _
      list(taskid = "BL.10intvl",
           subtask = "pac.ia.marg",
           fitting.type = "p2",
           pac.ia.transform = "std.pow", ## needed for pac.ia.spec
           STREAMVAR = c('ip0','port0','ip1','port1','dir'), ## needed for pac.bandwidth
           timeunit = 0.1, ## seconds for pktcnt/bytcnt, needed for [pkt|byt]cnt.* tasks
           pac.cnt.transform = "std", ## needed for pac.[pkt|byt]cnt.spec
           jobqueue.server = "localhost", ## use distributed computing across hosts
           )

    ##
    settings$subtask = "pac.ia.marg" 
    settings$subtask = "pac.ia.spec"
    settings$subtask = "pac.size.marg"
    settings$subtask = "pac.size.spec"
    settings$subtask = "pac.bandwidth"
    settings$subtask = "pac.cnt.pkt.marg"
    settings$subtask = "pac.cnt.pkt.spec"
    settings$subtask = "pac.cnt.byt.marg"
    settings$subtask = "pac.cnt.byt.spec"

    settings$subtask = "pac" 
    run.intvl.task(settings);
    
  }

  cat("\n>>> ", settings$subtask, " step 1\n", sep="")
  ## batch job
  if(settings$subtask == "pac.ia") {
    for(subtask in c("pac.ia.marg", "pac.ia.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "pac.size") {
    for(subtask in c("pac.size.marg", "pac.size.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "pac.cnt") {
    for(subtask in c("pac.cnt.pkt", "pac.cnt.byt")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "pac.cnt.pkt") {
    for(subtask in c("pac.cnt.pkt.marg", "pac.cnt.pkt.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "pac.cnt.byt") {
    for(subtask in c("pac.cnt.byt.marg", "pac.cnt.byt.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "pac") {
    for(subtask in c("pac.bandwidth", "pac.ia", "pac.size", "pac.cnt")) {
      settings$subtask _ subtask
      run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "flow.ia") {
    for(subtask in c("flow.ia.marg", "flow.ia.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "flow.dur") {
    for(subtask in c("flow.dur.marg", "flow.dur.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "flow.fsize0") {
    for(subtask in c("flow.fsize0.marg", "flow.fsize0.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "flow.fsize1") {
    for(subtask in c("flow.fsize1.marg", "flow.fsize1.spec")) {
      settings$subtask _ subtask; run.intvl.task(settings)
    }
    return()
  } else if(settings$subtask == "flow") {
    for(subtask in c("flow.ia", "flow.dur", "flow.fsize0", "flow.fsize1")) {
      settings$subtask _ subtask
      run.intvl.task(settings)
    }
    return()
  } 
  
  ## End of batch section
  
  cat(">>> ", settings$subtask, " step 2\n", sep="")
  print(settings)
  assert(!is.null(settings$taskid) &&!is.null(settings$subtask))
  settings$subtask.type _ mysystem("awk -F'.' '{print $1}'", settings$subtask);
  settings$subtask.type                 ## pac or flow
  settings$auxVar _ c("TIMESTAMP.OPTION","pacSize.type","LINKSPEED")

  settings$data.info _ oget(paste(settings$taskid,settings$subtask.type,
                         "task.df",sep=".")); dim(settings$data.info)
  nintvl <- nrow(settings$data.info); nintvl
  if(settings$subtask.type == "pac") {
    for(i.auxVar in settings$auxVar) {
      if(all(is.na(match(i.auxVar, names(settings$data.info))))) {
        assert(exists(i.auxVar))
        settings$data.info[,i.auxVar] _ rep(get(i.auxVar),len=nintvl)
      }
      settings$data.info[,i.auxVar] _ rep(settings$data.info[,i.auxVar],len=nintvl)
    }
    NULL
  }

  if(!is.null(settings$jobqueue.server) && settings$jobqueue.server != "") {
    ## jobqueue stuff
    jobName _ paste(settings$taskid, settings$subtask, sep="."); jobName
    initTask(jobName, seq(nrow(settings$data.info)), server=settings$jobqueue.server)
    nOutstandingJob _ as.numeric(getJobCount(jobName, server=settings$jobqueue.server));
    cat(">>> nOutstandingJob:", nOutstandingJob, "\n")
    ## end of jobqueue block
    for(dummy.iter in 0:nOutstandingJob) {
      ## jobqueue block
      if(file.exists(paste(".RDir/ALLDONE",jobName,sep="."))) break;
      jobid _ getNextJob(jobName, server=settings$jobqueue.server); cat("jobid: ", jobid, "\n")
      if(jobid == "ALLDONE") osave(paste("ALLDONE",jobName,sep="."), T)
      if(jobid == "ALLDONE" || jobid == "NA") break;
      iter = as.numeric(jobid)
      updateJob(jobName, jobid, status="running", server=settings$jobqueue.server)
      ## end of jobqueue block
      settings$runName _ run.one.intvl(settings, iter)
      updateJob(jobName, jobid, status="complete", server=settings$jobqueue.server)
    }
    ## only one job needs to do this summary step
    if(file.exists(paste(".RDir/ALLDONE",jobName,sep=".")) &&
       !file.exists(paste(".RDir/SUMMARY.IN.PROGRESS",jobName,sep="."))) {
      osave(paste("SUMMARY.IN.PROGRESS",jobName,sep="."), T)
      ## summarize
      ##
      ## 1. merge postscript files in the current working directory
      ##    from each interval
      merge.intvl.ps(settings$runName)
      
      ## 2. merge compLsts from each interval
      merge.intvl.compLst(settings$runName)
      
      ## 3. run summary functions to do summary plots
      summary.fcn _ get( paste("summary.intvl", settings$subtask, sep=".") )
      summary.fcn(settings)
      ## 4. drop task
      dropTask(jobName, server=settings$jobqueue.server)
    }
  } else {
    ## for(iter in seq(3)) { ## iter _ 1
    for(iter in seq(nrow(settings$data.info))) {
      settings$runName _ run.one.intvl(settings, iter)
    }
    merge.intvl.ps(settings$runName)
    merge.intvl.compLst(settings$runName)
    summary.fcn _ get( paste("summary.intvl", settings$subtask, sep=".") )
    summary.fcn(settings)
  }
  
  ## End.
}

run.one.intvl _ function(settings, iter) {
  ## 1. get object
  objnme _ settings$data.info[iter,"objnme"]; objnme
  obj _ oget(objnme); dim(obj)
  if(settings$subtask.type=="flow"|| settings$subtask.type=="subflow") {
    obj$time _ obj$start; NULL
  }
  if(settings$subtask.type!="subflow") {
    obj <- obj[order(obj$time),]; NULL
  } else {
    obj <- obj[order(obj$flowid, obj$subflowid),]; NULL
  }
  if(grepMatch(".ia",settings$subtask) ||
     grepMatch("pac.bandwidth",settings$subtask)) {
    if(sum((ia_InterArrival(obj$time))==0)>0) {
      cat(">>> warning:", sum(ia==0), "inter-arrivals are zero, skipped\n");
      obj _ obj[!duplicated(obj$time),,drop=F]
    }
  }
    
  ## 1. get various labels for plots
  ## intvlLab, intvlStr, intvl
  INTVL.WIDTH _ ceiling(diff(range(obj$time)))
  cat("INTVL.WIDTH:", INTVL.WIDTH,"\n")
  fmt _ paste("%0", ceiling(log10(nrow(settings$data.info)+1)), "d", sep="")
  tag _ get.intvl.summary(obj$time, INTVL.WIDTH=INTVL.WIDTH, intvl=iter,
                          fmt=fmt); tag
  tag _ update.tag.settings(tag, settings, iter);

  ## 2. for bandwidth calculation, modify the size depending on the pacSize.type
  if(settings$subtask.type == "pac") {
    pacSize.type _ settings$data.info[iter,"pacSize.type"]; pacSize.type
    obj$iplen _ adjustPacSize(obj$len, pacSize.type, target="iplen");
    obj$len _ adjustPacSize(obj$len, pacSize.type, target="wirelen");
    ## NOTE: iplen is the new variable, while len should really be wirelen
    ## 2b. for pktcnt/bytcnt calculate counts
    if(grepMatch("pac.cnt",settings$subtask)) {
      if(nrow(obj)>0) obj <- getcnt(obj, timeunit=settings$timeunit)
    }
  }
 
  ## 3. actual analysis 
  run.fcn _ get( paste("run.intvl", settings$subtask, sep=".") )
  settings$runName _ run.fcn(obj, tag)
  rm(list=c("obj"))
  return(settings$runName)
}


