
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

sapply.extractList _ function(lst, comp) {
  ##
  ## $Id: sapply.extractList.R,v 1.2 2002/01/30 22:28:02 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/sapply.extractList.R,v $
  ##
  if(F) {
    lst _ list(a=list(fit=list(para=list(d=.75, varRatio=0.89)),
		   weibull.me=list(shape=0.8, scale=0.6, label="DEMOa")),
	       b=list(fit=list(para=list(d=.9, varRatio=0.1)),
		   weibull.me=list(shape=0.5, scale=0.4, label="DEMOb")))
    comp _ c("d", "varRatio", "shape","label")
    sapply.extractList(lst, comp)
    sapply.extractList(lst, "d")
  }
  ## names(flattenList(lst[[1]]))
  tmp <- rbind(sapply(lst,
                      function(x, comp) cbind(unlist(extractList(x, comp))),
                      comp = comp))
  dfm <- data.frame(t(tmp)) ## sapply(dfm, data.class)
  names(dfm) _ comp ## dfm

  if(F) {
    for(nm in names(dfm)) {
      as.char _ as.character(dfm[[nm]])
      res _ numeric.field(as.char)
      if(res$ok) {
        dfm[[nm]] _ res$n
      } else {
        dfm[[nm]] _ as.char
      }
    }
  }
  ## sapply(dfm, data.class)
  dfm
}




