
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

smooth.spec _ function(x, smooth.m=4, spec.pgram.arg=list()) {
  ## smooth spectrum by averaging every 4 points
  ## note spec.pgram will ceiling the number of observations to 
  ##  a nice number so that fft can be computed efficiently, as
  ##  a result, the degree of freedom is not 2 for smooth.m=1.
  if(F) {
    x _ rnorm(1e5)
    tmp _ smooth.spec(x)
    tmp1 _ smooth.spec(x, spec.pgram.arg=list(taper=0.5))
    mean(tmp$spec)
    mean(tmp1$spec)
    plot(tmp$freq, tmp$spec)
  }
  ##browser()
  spec.pgram.arg.default <- list(spans=2, taper=0, pad=0,
				 detrend=F, demean=F)
  ## spans<2 will cause problem in spec.pgram()
  spec.pgram.arg <- updateList(spec.pgram.arg.default, 
			       spec.pgram.arg)
  ## my.spec.pgram <- funNoCrash
  ## my.spec.pgram$fun <- "spec.pgram"
  ia.spec <- spec.pgram(x, 
                        spans = spec.pgram.arg$spans, 
                        taper = spec.pgram.arg$taper, 
                        pad = spec.pgram.arg$pad, 
                        detrend = spec.pgram.arg$detrend, 
                        demean = spec.pgram.arg$demean, 
                        plot = F)
  if(is.null(ia.spec)) {
    cat("error in spec.pgram, return null instead!\n");
    return()
  }
  ## fix the "taper" problem (both in Splus and R)
  v <- mean(spec.taper(rep(1,length(x)),
                       p=spec.pgram.arg$taper)^2)
  ## ia.sp <- 10^(ia.spec$spec[-1]/10)/v ## this is for Splus
  ia.sp <- ia.spec$spec[-1]/v ## this is for R
  ia.fr <- ia.spec$freq[-1]
  if(smooth.m>1) {
    m <- smooth.m
    nn <- length(ia.fr)
    nblocks <- floor(nn/m)
    select <- rep(1:nblocks, rep(m, nblocks))
    select <- factor(select)
    ia.sp <- ia.sp[1:(nblocks * m)]
    ia.fr <- ia.fr[1:(nblocks * m)]
    ia.sp <- tapply(ia.sp, select, mean)
    ia.fr <- tapply(ia.fr, select, mean)
  }
  list(freq=ia.fr, spec=ia.sp, spec.std=ia.sp/mean(ia.sp), df=smooth.m*ia.spec$df)
}
