
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

spec.eval _ function(theta, fseq=seq(0,.5, by=0.01)) {
  ##
  ## compute |S(f)|^2, spectrum
  ## | sum_{k=0}^{p} theta_{k} exp(-2 pi k f) |^2
  ##
  ## e.g., spec.eval(c(1,-1))$spec^d             => fractional differencing
  ##       spec.eval(c(1,-phi1,-phi2))$spec^(-1) => AR model
  ##       spec.eval(c(1,theta1,theta2))$spec    => MA model
  ##
  if(F) {
    ll.ar <- ar(log(lynx), order=10) 
    spec <- spec.pgram(log(lynx),plot=T) 
    ll.spec.ar <- spec.ar(ll.ar, plot=F) 
    spec.plot(ll.spec.ar, add=T) 
    spec.plot(ll.spec.ar)
    phi _ ll.ar$ar[,,1]
    fseq _ ll.spec.ar$freq
    
    Sf _ 10*log10(1/spec.eval(c(1,-phi), fseq)$spec)
    plot(fseq, Sf, type="l")
    lines(ll.spec.ar$freq, ll.spec.ar$spec, type="l", col=3)
    
    Sf _ 10*log10((spec.eval(c(1,-1), fseq)$spec)^(-0.25))
    plot(fseq, Sf, type="l")
    plot(log10(fseq), log10(Sf), type="l")
  }
  
  if(F) { ## slower method
    Sf _ fseq
    for(i in 1:length(fseq)) {
      Sf[i] _ ((sum(theta * cos(-(0:(length(theta)-1))*2*pi*fseq[i])) )^2 +
               (sum(theta * sin(-(0:(length(theta)-1))*2*pi*fseq[i])))^2)
    }
  } else { ## faster method
    a _ b _ rep(0, length(fseq))
    for(i in 1:length(theta)) {
      a _ a + theta[i] * cos(-2*pi*fseq*(i-1))
      b _ b + theta[i] * sin(-2*pi*fseq*(i-1))
    }
    Sf _ (a^2+b^2)
  }
  list(freq=fseq, spec=Sf)
}
