
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

spectrum.plot _ function(fit, label=list(), psfile="", append=F,
                         xscale="original", type="fit", horizontal=F,
			 ...) {
  
  ##
  ## $Id: spectrum.plot.R,v 1.4 2002/03/11 03:29:28 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/spectrum.plot.R,v $
  ##
  
  if(F) {
    objNm _ "Test Object"
    d <- 0.25; x <- fracdiff.sim(n=500, ar=0, ma=-1, d=d)$series
    fit _ fit.fsd.log10spec.unbiased(x, init=init, type="p2")
    plt _ spectrum.plot(fit, label=list(main=objNm))
    plt _ spectrum.plot(fit, label=list(main=objNm), xscal="sqrt")
    
    plt _ spectrum.plot(fit, label=list(main=objNm), psfile="demo.ps")
    plt _ spectrum.plot(fit, xscale="original",
                         label=list(main=objNm), psfile="demo.ps")
    plt _ spectrum.plot(fit, xscale="original",
                         label=list(main=objNm), psfile="demo.ps", append=T)
    plt _ spectrum.plot(fit, label=list(main=objNm), 
			 type="geweke.residual", psfile="demo.ps")
    plt _ spectrum.plot(fit, label=list(main=objNm), 
			 type="fit.residual", psfile="demo.ps")
  }
  ten.log10spec.obs _ 10*fit$log10spec.obs.unbiased
  ten.log10spec.fitted _ 10*fit$log10spec.fitted
  geweke.sp _ 4*sin(pi* fit$freqseq)^2
  loggeweke.sp <- log10(geweke.sp)
  ## browser()
  lo.fit <- fitted.values(loess(ten.log10spec.obs ~ loggeweke.sp,
				span=0.5, degree=2,family="gaussian", trace.hat=c("approximate")))
  
  if(xscale=="sqrt") {
    x _ sqrt(fit$freqseq)
    xlab _ "sqrt(Frequency)"
  } else if(xscale=="original") {
    x _ fit$freqseq
    xlab _ "Frequency"
  } else {
    stop("xscale error")
  }

  if(type=="fit"){
    y _ ten.log10spec.obs
    plt _ xyplot(y~x, pch=SNet.settings$pch, col="black",
		 panel=function(x,y,ten.log10spec.fitted,lo.fit=NULL,...) {
                   panel.xyplot(x,y,...)
                   if(!is.null(lo.fit)) llines(x, lo.fit, col="red", lwd=2)
		   llines(x, ten.log10spec.fitted, col="blue", lwd=2)
		 },
		 ten.log10spec.fitted = ten.log10spec.fitted,
		 lo.fit=lo.fit
		 )
    ylab _ "10 Log Base 10 Averaged Periodogram (decibels)"
  } else if(type=="geweke.residual"){
    if(!is.null(lo.fit)) {
      y _ ten.log10spec.obs-lo.fit
      res.fit <- fitted.values(loess(y ~ fit$freqseq,
                                     span=0.5, degree=2,family="gaussian", trace.hat=c("approximate")))
      plt _ xyplot(y~x, pch=SNet.settings$pch, col="black",
                   panel=function(x,y, res.fit,...) {
                     panel.xyplot(x, y, ...)
                     llines(x, res.fit, col="red", lwd=2)
                     panel.abline(h=0, col="blue", lwd=2)
                   },
                   res.fit=res.fit, 
                   )
      ylab _ "Residual geweke, 10 Log Base 10 Averaged Periodogram (decibels) - geweke smoothing"
    } else { ## empty plot
      y _ ten.log10spec.obs
      plt _ xyplot(y~x, panel=function(x,y) { })
      ylab _ "Empty Plot"
    }
  } else if(type=="fit.residual"){
    y _ ten.log10spec.obs-ten.log10spec.fitted
    res.fit <- fitted.values(loess(y ~ fit$freqseq,
				   span=0.5, degree=2,family="gaussian", trace.hat=c("approximate")))
    plt _ xyplot(y~x, pch=SNet.settings$pch, col="black",
		 panel=function(x,y,res.fit=NULL,...) {
		   panel.xyplot(x, y, ...)
		   if(!is.null(res.fit)) llines(x, res.fit, col="red", lwd=2)
		   panel.abline(h=0, col="blue", lwd=2)
		 },
		 res.fit=res.fit, 
		 )
    ylab _ "Residual fitted, 10 Log Base 10 Averaged Periodogram (decibels) - fitted"
  } else {
    stop("plotting type error")
  }
  
  paraString _ paste("varRatio=", round(as.list(fit$para)$varRatio,3),
                     " d=", round(as.list(fit$para)$d,3),
                     " sigma.lSq=", round(as.list(fit$para)$sigma.lSq,3))
  if(!is.null(fit$etp)) paraString <- paste(paraString,
					    " etp=", round(fit$etp,3), sep="")
  plt _ update.plot.labels(plt,
                           xlab = xlab, 
                           ylab = ylab, 
                           sub = paraString,
                           label=label)

  if(psfile!="") {
    trellis.device("postscript", color = T, file = psfile, 
		   horizontal=horizontal, append=append,
                   paper="letter", bg = "white", first=T)
    print(plt)
    dev.off()
  } 
  plt
}

