
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

subset.object _ function(objLst, var="dir") {
  ## for each packet object in the list,
  ## subset it by the levels of the given variable
  new.objLst _ NULL
  for(i in 1:length(objLst)) { ## i _ 1
    cat(i, " ", objLst[i], "\n");
    obj _ oget(objLst[i]); dim(obj);
    tmpvar _ obj[[var]]
    for(tmpvar.i in sort(unique(tmpvar))) {
      sel _ tmpvar == tmpvar.i
      objnme _ paste(objLst[i], ".", var, tmpvar.i, sep="")
      if(sum(sel)>0) {
        osave(objnme, obj[sel,,drop=F])
        new.objLst _ c(new.objLst, objnme)
      }
    }
    rm(list=c("obj"))
  }
  new.objLst
}
