
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## $Id: time.plot.R,v 1.2 2002/03/11 03:29:28 dxsun Exp $

if(F) {
  foo _ function(x) {
    print(deparse(substitute(x)))
  }
}

time.plot _ function(x, y, label=list(),
                     psfile="", append=F, horizontal=F, ...) {
  if(F) {
    fsize _ abs(rnorm(10000)); time _ sort(runif(10000))
    time.plot(time, fsize)
    time.plot(time, fsize, main="My Time Plot",
              label=list(sub=list(label="My Sub-Title", col="red")))
    time.plot(time, fsize, psfile="demo.ps")
  }
  plt _ xyplot(y ~ x, panel=panel.myxyplot, ...)
  plt _ update.plot.labels(plt,
                           xlab="Time",
                           ylab=deparse(substitute(y)),
                           label=label)
  plt$main$cex _ plt$sub$cex _ 0.8
  
  if(psfile!="") {
    trellis.device("postscript", 
                   color = T, file = psfile,
                   horizontal=horizontal, append=append,
                   paper="letter", bg = "white", first=T)
    print.trellis(plt)
    dev.off()
  }
  plt
}

log2.time.plot _ function(x, y, label=list(),
                          psfile="", append=F, horizontal=F, ...) {
  if(F) {
    fsize _ abs(rnorm(1000000)); time _ sort(runif(length(fsize)))
    ord _ order(fsize)
    log2.time.plot(time, fsize)
    log2.time.plot(time[ord], fsize[ord], psfile="demo.ps")
  }
  plt _ xyplot(log2(y) ~ x, panel=panel.myxyplot, ...)
  plt _ update.plot.labels(plt,
                           xlab="Time",
                           ylab=paste("Log2(",
                             deparse(substitute(y)), ")", sep=""),
                           label=label)
  plt$main$cex _ plt$sub$cex _ 0.8

  if(psfile!="") {
    trellis.device("postscript", 
                   color = T, file = psfile, 
                   horizontal=horizontal, append=append,
                   paper="letter",bg = "white", first=T)
    print.trellis(plt)
    dev.off()
  } 
  plt
}


