
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## $Id: unif.qqplot.R,v 1.3 2002/03/21 07:02:17 dxsun Exp $

unif.qqplot _ function(y,
                       label=list(),
                       psfile="",
                       append=F,
		       horizontal=F,
                       ...) {
  ##
  ## $Id: unif.qqplot.R,v 1.3 2002/03/21 07:02:17 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/unif.qqplot.R,v $
  ##
  if(F) {
    fsize _ runif(1000)
    unif.qqplot(fsize)
    unif.qqplot(fsize, psfile="demo.ps")
  }
  
  y.sort _ sort(y)

  mypanel <- function(x,y, ...){ ## y is already log2(y)
    ## panel.qqmath(x,y,col=1,cex=1.5,pch=".", ...) 
    out _ reduce.plot.points(x, y, do.sort=T); x _ out$x; y _ out$y
    panel.qqmath(x,y, col="black", pch=SNet.settings$pch, ...)
  }

  plt _ qqmath2(~y.sort, dist=qunif,
               ## aspect=0.75,
               panel=mypanel, ...)
  plt _ update.plot.labels(plt,
                           xlab="Uniform Distribution Quantile",
                           ylab=deparse(substitute(y)),
                           label=label)
  ## plt$main$cex _ plt$sub$cex _ 0.8

  if(psfile!="") {
    trellis.device("postscript", color = T, file = psfile, append=append,
		   horizontal=horizontal,
                   paper="letter", bg = "white", first=T)
    print.trellis(plt)
    dev.off()
  } 
  plt

}
