
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

update.plot.labels _ function(plt, xlab, ylab, main, sub, label) {
  ##
  ## plt: an existing trellis plot object
  ## xlab/ylab/main/sub: can be either string, or list of (label,col,cex,font)
  ## label is a list of (xlab,ylab,main,sub) that override the individual
  ##   xlab/ylab/main/sub argumnets
  ##
  ## Note: in R, the xlab/ylab/main/sub components of a trellis plot object
  ##       must be lists of (label,col,cex,font), a simple text string does not work
  ##

  if(F) {
    plt _ xyplot(runif(10) ~ seq(10),col="red", pch="o")
    plt _ update.plot.labels(plt, xlab="My X", sub="My Sub",
                             label=list(xlab="New X", main="New Main",
                               ylab=list(label="Better Y", col="blue")))
    plt
  }
  
  if(missing(label)) label _ list()
  
  if(!missing(xlab) && is.null(label$xlab)) label$xlab _ xlab
  if(!is.null(label$xlab) && is.character(label$xlab)) label$xlab _ list(label=label$xlab)

  if(!missing(ylab) && is.null(label$ylab)) label$ylab _ ylab
  if(!is.null(label$ylab) && is.character(label$ylab)) label$ylab _ list(label=label$ylab)

  if(!missing(main) && is.null(label$main)) label$main _ main
  if(!is.null(label$main) && is.character(label$main)) label$main _ list(label=label$main)

  if(!missing(sub) && is.null(label$sub)) label$sub _ sub
  if(!is.null(label$sub) && is.character(label$sub)) label$sub _ list(label=label$sub)

  for(nm in c("xlab", "ylab", "main", "sub")) {
    if(!is.null(label[[nm]]) && is.character(label[[nm]])) label[[nm]] _ list(label=label[[nm]])
    if(is.null(plt[[nm]])) {
      plt[[nm]] _ list(label=" ", col="black", cex=1, font=1)
      if(nm == "main") plt[[nm]]$cex _ 1.2
    }
    plt[[nm]] _ updateList(plt[[nm]], label[[nm]])
  }
  ## print(plt[c("xlab", "ylab", "main", "sub")])
  plt
}
