
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

updateList <- function(default, newSupply)
{
  ## partial replace default with new supplied components.
  if(F) {
    x _ list("A"=1:10, "B"=1)
    y _ list("C"=1:5, "B"=10)
    updateList(x, y)
  }
  d <- default
  ## if(!is.null(newSupply)) d[names(newSupply)[id]] <- newSupply[id]
  if(length(newSupply)>0) {
    id <- sapply(newSupply, function(x){!is.null(x)})
    d[names(newSupply)[id]] <- newSupply[id]
  }
  d
}

initialList <- function(nmes){
  x <- vector("list", length(nmes))
  names(x) <- nmes
  x
}

dropList <- function(lst, nmes) {
  if(F) {
    x _ list("A"=1:10, "B"=1)
    y _ list("C"=1:5, "B"=10)
    dropList(x, c("A"))
  }
  id _ is.na(match(names(lst), nmes)); id
  lst[id] 
}
