
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##


##
## $Id: weibull.R,v 1.5 2002/03/05 06:53:39 dxsun Exp $
## $Source: /packet/CVSRoot/SNet_R/SNet/R/weibull.R,v $
##
weibull.estimate _ function(x, type="ME") {
  val _ get(paste("weibull",type,sep="."))(x)
  val$type _ type
  val
}

weibull.ME _ function(x) {
  ## moment estimate
  if(F) {
    x _ rweibull(10000, shape=.7, scale=.24)
    weibull.ME(x)
  }
  ## sd of exponential variable: pi/sqrt(6)
  sd.log2.exp _ pi/sqrt(6)/log(2)
  ## y _ logb(x,2)
  y _ log2(x)
  slp _ sqrt(var(y))/sd.log2.exp
  shape.par _ 1/slp
  ## intcpt _ median(y) - slp * logb(qexp(.5),2)
  scale.par _ mean(x)/gamma(1/shape.par + 1)
  list(shape=shape.par, scale=scale.par)
}
                 
## MLE using nlmin
weibull.MLE _ function(x) {
  if(F) {
    x _ rweibull(1000, shape=.8, scale=.001)
    x _ rweibull(1000, shape=.8, scale=.5)
    fit _ weibull.MLE(x)
    fit
  }
  
  x _ x[x>0] 
  ## x.glob _ x
  obj _ function(p) {
    ## print(objects(frame=sys.parent()-2))
    ## x _ x.glob
    ## x _ get("x", frame=sys.parent()-2)
    ## log-likelihood
    ## alpha _ p[1]; beta _ p[2]
    beta _ p[1]; alpha _ p[2]
    val _ -mean(log(beta)-beta*log(alpha)+beta*log(x)-log(x)-
                x^beta*alpha^(-beta))
    cat(">>> weibull.MLE/obj: shape scale val:",
        p[1], p[2], val, "\n")
    if(!is.finite(val)) val _ 1e100
    val
  }
  
  obj.derivative _ function(p) {
    ## x _ get("x", frame=sys.parent()-2)
    ## x _ x.glob
    ## alpha _ p[1]; beta _ p[2]
    beta _ p[1]; alpha _ p[2]
    val _ 
      - c(mean(1/alpha*beta*(-1+x^beta*alpha^(-beta))),
          mean((1+beta*log(x)-beta*log(alpha)-
                alpha^(-beta)*x^beta*beta*log(x)+
                alpha^(-beta)*x^beta*beta*log(alpha))/beta)
          )
    cat(">>> weibull.MLE/obj.derivative: shape scale derivative:",
        p[1], p[2], ",", val, "\n")
    if(any(!is.finite(val))) val[!is.finite(val)] _ 1e100
    val
  }
  
  ## maple code
  ## f := beta/alpha * (x/alpha)^(beta-1) * exp( - (x/alpha)^beta);
  ## diff(f, alpha);
  ## diff(f, beta);
  initFit _ weibull.ME(x)
  ## par0 _ c(initFit$scale, initFit$shape)
  par0 _ c(initFit$shape, initFit$scale)
  cat(">>> starting optim()\n")
  cat(">>> initial,   shape scale val:", initFit$shape, initFit$scale, obj(par0), "\n")
  ## out _ nlminb(par0, obj, obj.derivative, lower=c(0,0), upper=c(Inf, Inf))
  out _ optim(par0, obj, obj.derivative, method="L-BFGS-B",
              lower=c(1e-10, 1e-10), upper=c(1e10, 1e10))
  cat(">>> optimized, shape scale val:", out$par[1], out$par[2], obj(out$par), "\n")
  ## list(shape=out$parameters[2], scale=out$parameters[1])
  ## list(shape=out$par[2], scale=out$par[1])
  list(shape=out$par[1], scale=out$par[2])
}







