
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

panel.weibull.qqplot <- function(x,y,...) { ## y is already log2(y)
  ## horizontal lines
  ## abline(v = quantile(x, 0.25 * c(1:3)), col = 2)
  panel.abline(v = quantile(x, 0.25 * c(1,3)), col = 1)
  panel.abline(v = quantile(x, c(0.1, 0.9)), col = 1)
  panel.abline(v = quantile(x, c(0.05, 0.95)), col = 1)

  ## lines and text
  ## inter-quartile
  y0 <- quantile(y, c(0.25, 0.75))
  x0 <- quantile(x, c(0.25, 0.75))
  slope <- (y0[2] - y0[1])/(x0[2] - x0[1])
  intercept <- y0[2] - x0[2] * slope
  panel.abline(intercept, slope, col = "blue")
  str <- paste("shape=",round(1/slope,2))
  cat(str, "\n")
  ltext(min(x) + 3, max(y) - 0.2, str, col="black", cex = 0.75)
  ## exponential
  panel.abline(log2(mean(2^(y))), 1, col = "red")
  ## shape =1 , scale = mean(2^(log2(y)))
  ## qqplot
  ## panel.qqmath(x,y,col=1,cex=1.5,pch=".") 
  out _ reduce.plot.points(x, y, do.sort=T); x _ out$x; y _ out$y
  panel.qqmath(x,y,col=1,pch=SNet.settings$pch)
}

weibull.qqplot _ function(y, cond,
                          label=list(),
                          psfile="",
                          append=F,
                          estimate=list(),
			  horizontal=F,
                          ...) {
  ##
  ## $Id: weibull.qqplot.R,v 1.3 2002/03/21 07:02:17 dxsun Exp $
  ## $Source: /packet/CVSRoot/SNet_R/SNet/R/weibull.qqplot.R,v $
  ##
  ## estimate: list(shape, scale, type), where type is "ME" or "MLE"
  ##           result from weibull.estimate(x, type="ME")
  ##                       weibull.estimate(x, type="MLE")
  
  if(F) {
    y _ rexp(1000)^(1/.7)
    type _ paste(rep(c("A","B"),length(y)/2))
    weibull.me _ weibull.ME(y)
    weibull.mle _ weibull.MLE(y)
    subStr _ paste("MLE: shape=", round(weibull.mle$shape,3),
                   " scale=", round(weibull.mle$scale,3))

    weibull.qqplot(y)
    weibull.qqplot(y, cond=type)
    weibull.qqplot(y, cond=type, label=list(sub=subStr, main="weibull.qqplot"))
    weibull.qqplot(y, cond=type, label=list(sub=subStr, main="weibull.qqplot"),
                   psfile="demo.ps")
  }

  ##browser()
  if(missing(cond)) {
    y _ sort(y); formu <- formula(~log2(y))
  } else {
    ord <- order(y); y <- y[ord]; cond <- cond[ord]  ##order
    ## condvar <- deparse(substitute(cond))
    ## condvar _ cond
    ## assign(condvar, factor(cond), frame=sys.parent())
    ## formu <- formula(paste("~log2(y)|", condvar))
    formu <- formula(~log2(y)|cond)
  }

  ## col: 8-red, 6-blue
  
  plt _ qqmath2(formu, dist=function(p) log2(qexp(p)),
               ## aspect=0.75,
               panel=panel.weibull.qqplot, ...)
  if(is.null(label$sub)) {
    if(length(estimate)==0) {
      para _ weibull.estimate(y, type="ME")
    } else {
      para _ estimate
    }
    label$sub _ paste(para$type, ":shape=", round(para$shape,2),
                      ", scale=", round(para$scale,2),
                      "; EXP:shape=1,scale=",round(mean(y),2), sep="")
  }
  plt _ update.plot.labels(plt,
                           xlab="log2(qexp(p))",
                           ylab="log2(x) (weibull qqplot)",
                           label=label)
  ## plt$main$cex _ plt$sub$cex _ 0.8

  if(F) { ## put title on side
    plt$page _ eval(parse(text=paste("function(n) mtext(\"",
                            plt$main,
                            "\",side=4,cex=0.8,adj=0.5,line=1.5,outer=T)",
                            sep="")))
    plt$main _ NULL
  }

  if(psfile!="") {
    trellis.device("postscript", color = T, file = psfile,
                   append=append, horizontal=horizontal,
                   paper="letter", bg = "white", first=T)
    print.trellis(plt)
    dev.off()
  } 
  plt
}
