
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##


##
## $Id: zread.table.R,v 1.3 2002/02/01 22:58:47 dxsun Exp $
## $Source: /packet/CVSRoot/SNet_R/SNet/R/zread.table.R,v $
##

zread.table _ function(file, hdfile="", sep="", save=F, make.names=F, ...) {
  ## 
  ## hdfile is the file containing the names of the columns
  ## 
  if(F) {
    pushd("/n/data/packet/FlowDetail/Thu_Dec_9_06_00_00_1999")
    x _ zread.table("99.12.10.h05.flow.gz", save=T)
    x _ zread.table("99.12.10.h05.flow.gz", hdfile="flow.header")
    x[1:5,]
    x _ zread.table("99.12.10.h05.flow.gz")
    x[1:5,]
    popd()
  }

  file _ getfile(file)
  if(is.null(file)) return()

  objname _ system(paste("basename ", file), TRUE)
  if(save) {
    if(make.names) {
      objname _ make.names(objname)
    }
  }
  
  ## tmp _ tempfile("zread.table.")
  tmp _ paste("zread.table.", system("echo $$", TRUE), sep = "")
  on.exit(unlink(tmp)) 
  cmd _ paste("gzip -cdfq", file, ">", tmp)
  cat(cmd, "\n");
  system(cmd)
  ## x _ read.table(tmp, sep=sep, ...)
  cat(">>> read.table.fast(", names(list(...)), ")\n");
  x _ read.table.fast(tmp, sep=sep, ...)
  if( hdfile!="" && !is.null(getfile(hdfile)) ) {
    nms _ scan(getfile(hdfile), what="", sep=sep)
    names(x) _ nms
  }
  if(save) {
    osave(x, objname)
    return(invisible(x))
  } else {
    return(x)
  }
}

read.table.fast _ function(file, sep=" ", header=F, ...) {
  if(F) {
    ## avoid the unnecessary stuff in the current very slow read.table() 
    file="tmp2.tab"; sep=" "; header=F
    ## test on file with 100,000 lines
    date(); x _ read.table.fast(file); date() ##  68sec
    date(); x _ read.table(file); date()      ## 409sec
  }
  x0 _ scan(file, what="", sep=sep, nlines=1)
  nc _ length(x0)
  x _ matrix(scan(file, what="", sep=sep), ncol=nc, byrow=T)
  if(header) {
    hdr _ x[1,]
    x _ data.frame(x[-1,,drop=F])
  } else {
    x _ data.frame(x)
  }
  x _ reclass.data.frame(x)
  ## print(sapply(x, data.class))
  x
}
