
##
## Copyright (c) 1998-2002, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##
## http://cm.bell-labs.com/stat/InternetTraffic
##

## cat *.R | grep function | grep '^[A-z]' | awk '{printf "\"%s\",\n",$1}' | grep -v '('
if(F) {
  fcns _ c(

"addtolist",
"altRunlen",
"as.data.frame.character",
"as.data.frame.matrix",
"assert",
"getcnt",
"rDiscreteWeibull",
"dDiscreteWeibull",
"dDiscreteWeibull.deriv",
"fitDiscreteWeibull.MLE",
"fitDiscreteWeibull.tailprob.ls",
"discreteWeibull.qqplot",
"tailProb",
"cumProb",
"drop.names",
"flattenList",
"extractList",
"fit.fsd.log10spec.unbiased",
"flowplot",
"FOR",
"gaussianize",
"standardize",
"sqrt.standardize",
"pwd",
"pushd",
"popd",
"get.intvl.df",
"ts2POSIXct",
"ts2intvl",
"intvl.label",
"get.intvl.summary",
"geweke.spec",
"header.strip",
"InterArrival",
"model.spec",
"nstep.predict.err",
"nstep.predict.err.series",
"entropy",
"entropy.series",
"entropy.model",
"movingMean",
"mysystem",
"panel.myxyplot",
"myxyplot",
"normal.qqplot",
"log2normal.qqplot",
"panel.qqnorm",
"ols",
"osave",
"oget",
"orm",
"pareto.qqplot",
"paste.ns",
"printf",
"qlen0.finite.buffer",
"qlen0",
"qlen",
"read.flow",
"check.numeric",
"reclass.data.frame",
"run.intvl.flow.ia.marg",
"summary.intvl.flow.ia.marg",
"run.intvl.flow.ia.spec",
"summary.intvl.flow.ia.spec",
"run.intvl.flow.dur.marg",
"summary.intvl.flow.dur.marg",
"run.intvl.flow.dur.spec",
"summary.intvl.flow.dur.spec",
"run.intvl.flow.fsize0.marg",
"summary.intvl.flow.fsize0.marg",
"run.intvl.flow.fsize0.spec",
"summary.intvl.flow.fsize0.spec",
"run.intvl.flow.fsize1.marg",
"summary.intvl.flow.fsize1.marg",
"run.intvl.flow.fsize1.spec",
"summary.intvl.flow.fsize1.spec",
"run.intvl.pac.ia.marg",
"run.intvl.pac.ia.spec",
"run.intvl.pac.size.marg",
"run.intvl.pac.size.spec",
"run.intvl.pac.bandwidth",
"run.intvl.pac.cnt.pkt.marg",
"run.intvl.pac.cnt.byt.marg",
"run.intvl.pac.cnt.marg",
"run.intvl.pac.cnt.pkt.spec",
"run.intvl.pac.cnt.byt.spec",
"run.intvl.pac.cnt.spec",
"summary.intvl.pac.ia.marg",
"summary.intvl.pac.ia.spec",
"summary.intvl.pac.size.marg",
"summary.intvl.pac.size.spec",
"summary.intvl.pac.cnt.pkt.marg",
"summary.intvl.pac.cnt.byt.marg",
"summary.intvl.pac.cnt.marg",
"summary.intvl.pac.cnt.pkt.spec",
"summary.intvl.pac.cnt.byt.spec",
"summary.intvl.pac.cnt.spec",
"summary.intvl.pac.bandwidth",
"update.tag.settings",
"update.tag.runName",
"include.assign.result",
"adjustPacSize",
"getMinPacSize",
"template.sample",
"template.spec.fit",
"frac.back2back",
"include.bandwidth.plot",
"include.ia.vs.size.plot",
"include.plot.par.vs.rate",
"compLst2df",
"merge.intvl.ps",
"merge.intvl.compLst",
"run.intvl.task",
"sapply.extractList",
"smooth.spec",
"spec.eval",
"spectrum.plot",
"subset.object",
"time.plot",
"log2.time.plot",
"tx11",
"tps",
"unfold.data.frame",
"unif.qqplot",
"updateList",
"initialList",
"dropList",
"update.plot.labels",
"panel.weibull.qqplot",
"weibull.qqplot",
"weibull.estimate",
"weibull.ME",
"weibull.MLE",
"zread.table",
"read.table.fast",

           )
  for(fcn in fcns) {
    cat(">>>", fcn, "\n")
    fcnstr _ deparse(get(fcn))
    indx _ seq(length(fcnstr))[fcnstr=="{"][1]
    fcnstr _ c(fcnstr[1:indx],
               paste("cat(\">>> starting ",fcn,"()\",date(),\"\\n\")",sep=""),
               fcnstr[-c(1:indx,length(fcnstr))],
               fcnstr[length(fcnstr)])
    assign(fcn, eval(parse(text=fcnstr)))
  }
  
}
