#!/usr/bin/perl -w

## $Id: jobqueue.pl,v 1.15 2002/03/21 18:54:06 dxsun Exp $
## $Source: /home/dxsun/Comp/myutil/LDCS/RCS/jobqueue.pl,v $

## need DBI.pm (perl-DBI-1_13-1_i386.rpm)
## need DBD/mysql.pm (perl-MySQL-1_2202-1_i386.rpm)
## sudo rpm -ivh perl-DBI-1_13-1_i386.rpm
## sudo rpm -ivh perl-MySQL-1_2202-1_i386.rpm

$USAGE_STRING =   
  "Specify ONLY one of the following types:\n" .
  "  -viewTask -task taskname\n" .
  "  -viewAllTasks\n" .
  "  -dropTask -task taskname\n" .
  "  -initTask -task taskname < a_list_of_job_id\n" .
  "     (initTask does not override existing task, skip if task already exists)\n" .
  "  -reInitTask -task taskname < a_list_of_job_id\n" .
  "     (dropTask first, and then initTask)\n" .
  "  -getNextJob -task taskname\n" .
  "     (gives jobid, NA, or ALLDONE)\n" .
  "  -getJobCount -task taskname\n" .
  "     (get the number of outstanding jobs, not complete/running)\n" .
  "  -updateJob -task taskname -jobid jobid -status [complete/running/abort/init]\n" .
  "     (only need jobid and status, host/cwd/time will be updated automatically)\n" .
  "  -abortJob -task taskname < a_list_of_job_id\n" .
  "  -abortAllJobs -task taskname\n" .
  "     (abort all non-complete jobs)\n" .
  "";

$opt_server="data";
$opt_task="";
$opt_jobid="";
$opt_status="";

$opt_viewTask=0;
$opt_viewAllTasks=0;
$opt_dropTask=0;
$opt_initTask=0;
$opt_reInitTask=0;
$opt_getNextJob=0;
$opt_getJobCount=0;
$opt_updateJob=0;
$opt_abortJob=0;
$opt_abortAllJobs=0;
&mGetopts('viewTask|viewAllTasks|dropTask|initTask|reInitTask' .
	  '|getNextJob|getJobCount|updateJob|abortJob|abortAllJobs' .
	  '|jobid:|status:|task:|server:');

$sum=
  $opt_viewTask+ 
  $opt_viewAllTasks+ 
  $opt_dropTask+
  $opt_initTask+
  $opt_reInitTask+
  $opt_getNextJob+ 
  $opt_getJobCount+ 
  $opt_updateJob+
  $opt_abortJob+
  $opt_abortAllJobs;

if($sum==0) {
  ## print STDERR ">>> no option is given, show all active task names instead\n";
  $opt_viewTask=1;
}
## if($opt_task eq "") {
##   ## print STDERR ">>> no task is given, show all active task names instead\n";
##   $opt_viewTask=1;
## }

$mysql_db="jobqueueDB";
$mysql_user="jobqueue";
$mysql_passwd="jobqueue";

use DBI;

## DBI:servertype:database:hostname:port
$dbh = DBI->connect("DBI:mysql:${mysql_db}:${opt_server}", 
		    $mysql_user, $mysql_passwd);
if(! $dbh) {
  print STDERR ">>> error connecting mysql:${mysql_db}:${opt_server}\n";
  exit(1);
} else {
  print STDERR ">>> mysql:${mysql_db}:${opt_server} connected\n";
}

&getBasicInfo(); ## get $USER/$HOSTNAME/$CWD/$DATESTR

if($opt_task =~ /\./) {
  print STDERR ">>> $opt_task should be a valid mysql table name, no . in the name\n";
  $opt_task =~ s/\./_/g;
  print STDERR ">>> changed to $opt_task\n";
}
$task = $USER . "_" . $opt_task;
if($opt_viewTask) {
  &viewTask();
} elsif($opt_viewAllTasks) {
  &viewAllTasks(1);
} elsif($opt_dropTask) {
  &dropTask();
  &viewAllTasks(0);
} elsif($opt_initTask) {
  &initTask();
  &viewTask();
} elsif($opt_reInitTask) {
  &dropTask();
  &initTask();
  &viewTask();
} elsif($opt_getNextJob) {
  $jobid = &getNextJob();
  print "$jobid\n";
} elsif($opt_getJobCount) {
  $jobcount = &getJobCount();
  print "$jobcount\n";
} elsif($opt_updateJob) {
  &updateJob();
  ## &viewTask();
} elsif($opt_abortJob) {
  &abortJob();
  ## &viewTask();
} elsif($opt_abortAllJobs) {
  &abortAllJobs();
  ## &viewTask();
}
## if(!opt_dropTask) { 
##   &viewTask();
## }

exit(0);

sub getBasicInfo {
  $HOSTNAME = &standardizeHostname($ENV{'HOSTNAME'});
  if($HOSTNAME eq '') {
    $HOSTNAME = &standardizeHostname($ENV{'HOST'});
  }
  if($HOSTNAME eq '') {
    $HOSTNAME = &standardizeHostname(`hostname`);
  }
  $USER = $ENV{'USER'};
  $CWD = `pwd`; chomp $CWD; ## print "CWD=$CWD\n";
  $DATESTR = `date '+%Y/%m/%d-%H:%M:%S'`; chomp $DATESTR;
}

sub standardizeHostname {
  local($name) = @_;
  $name =~ s/\s*$//;
  $name =~ s/\..+$//;
  $name =~ tr/A-Z/a-z/;
  return($name);
}

sub dropTask {
  $query = $dbh->prepare("DROP TABLE IF EXISTS $task");
  ## not a idea to drop other user's tasks
  ## $query = $dbh->prepare("DROP TABLE IF EXISTS $opt_task");
  $query->execute;
}

sub initTask {
  @tables = $dbh->func('_ListTables');
  foreach $table (@tables) {
    if($table eq $task) {
      print (">>> $task already existed, skip\n");
      exit(0);
    }
  }

  $query = $dbh->prepare("CREATE TABLE $task (
jobid  VARCHAR(128) NOT NULL PRIMARY KEY,
status VARCHAR(16),
host   VARCHAR(128),
start  VARCHAR(22),
latest VARCHAR(22)
)");
## status ENUM('init','running','complete','abort'),
  $query->execute or die(">>> error creating table $task\n");

  local(@flds,$i,$jobid);
  ## insert records;
  while(<>) {
    chomp;
    s/^\s+//; 
    s/\s+$//;
    if(/\S+/) {
      @flds = split(/ /);
      foreach $i (0..$#flds) {
	($jobid,$status,$host,$start,$latest)=($flds[$i],"init","","","");
	$query = $dbh->prepare("INSERT INTO $task (jobid,status,host,start,latest) VALUES " . 
			       "(\"$jobid\",\"$status\",\"$host\",\"$start\",\"$latest\")");
	$query->execute;
      }
    }
  }
}

sub viewTask {
  if($opt_task eq "") { ## show all tasks
    &viewAllTasks(0);
  } else {
    $query = $dbh->prepare("SELECT * FROM $task");
    if(!($query->execute)) {
      $query = $dbh->prepare("SELECT * FROM $opt_task");
      $query->execute;
    }
    ## if(! $query) { ## table not exist ot empty
    ## 	 print STDERR ">>> error selecting from table $task\n";
    ## 	 exit(1);
    ## }
    print "jobid,status,host,start,latest\n";
    while(($jobid,$status,$host,$start,$latest) = $query->fetchrow_array) {
      print "$jobid,$status,$host,$start,$latest\n";
    }
  }
}

sub viewAllTasks {
  local($show_detail)=@_;
  $query = $dbh->prepare("SHOW TABLES");
  $query->execute;
  $n = 0;
  while(($name) = $query->fetchrow_array) {
    if($n==0) {
      print ">>> all active tasks:\n";
    }
    $n++;
    print "$name\n";
    if($show_detail) {
      ## print table detail
      $query2 = $dbh->prepare("SELECT * FROM $name");
      $query2->execute;
      print "jobid,status,host,start,latest\n";
      while(($jobid,$status,$host,$start,$latest) = $query2->fetchrow_array) {
	print "$jobid,$status,$host,$start,$latest\n";
      }
      ## check if all jobs are complete
      $query2 = $dbh->prepare("SELECT COUNT(jobid) as count FROM $name WHERE status != 'complete'");
      $query2->execute;
      ($count) = $query2->fetchrow_array;
      print ">>> $count incomplete jobs\n";
      if($count==0) {
	$name =~ s/^[^_]+_//;
	print ">>> alldone: $0 -drop -task $name\n";
      }
      print "\n";
    } 
  }
  if($n==0) {
    print ">>> no active tasks\n";
  }
}

sub getNextJob {
  $query = $dbh->prepare("SELECT * FROM $task WHERE (status != 'complete' && status != 'running')");
  $query->execute;
  if( ($jobid,$status,$host,$start,$latest) = $query->fetchrow_array) {
    print STDERR "$jobid,$status,$host,$start,$latest\n";
    ($status,$host,$start,$latest)=("running","${HOSTNAME}:${CWD}",$DATESTR,"");
    $query = $dbh->prepare("UPDATE $task SET status='$status',host='$host',start='$start',latest='$latest'" .
			   " WHERE jobid = \"$jobid\"");
    $query->execute;
    return($jobid);
  }
  ## check if all completed
  $query = $dbh->prepare("SELECT * FROM $task WHERE (status = 'running')");
  $query->execute;
  if( ($jobid,$status,$host,$start,$latest) = $query->fetchrow_array) {
    return("NA"); ## no job available, but still some running
  }
  return("ALLDONE"); ## no job available, but still some running
}

sub updateJob {
  if($opt_status ne 'init' &&
     $opt_status ne 'running' &&
     $opt_status ne 'complete' &&
     $opt_status ne 'abort') {
    print STDERR ">>> status must be one of init/running/complete/abort\n";
    exit(1);
  }
  ($jobid,$status,$host,$latest)=($opt_jobid, $opt_status, "${HOSTNAME}:${CWD}", $DATESTR);
  $query = $dbh->prepare("UPDATE $task SET status='$status',host='$host',latest='$latest'" .
			 " WHERE jobid = \"$jobid\"");
  $query->execute;
}

sub abortJob {
  while(<>) {
    chomp;
    s/^\s+//; 
    s/\s+$//;
    if(/\S+/) {
      @flds = split(/ /);
      foreach $i (0..$#flds) {
	($jobid,$status,$host,$latest)=($flds[$i],"abort","${HOSTNAME}:${CWD}",$DATESTR);
	$query = $dbh->prepare("UPDATE $task SET status='$status',host='$host',latest='$latest'" .
			       " WHERE jobid = \"$jobid\"");
	$query->execute;
      }
    }
  }
}
sub abortAllJobs {
  $query = $dbh->prepare("SELECT * FROM $task WHERE (status != 'complete' && status != 'init')");
  $query->execute;
  while( ($jobid,$status,$host,$start,$latest) = $query->fetchrow_array) {
    print STDERR "abort: $jobid,$status,$host,$start,$latest\n";
    ($status,$host,$latest)=("abort","${HOSTNAME}:${CWD}", $DATESTR);
    $query2 = $dbh->prepare("UPDATE $task SET status='$status',host='$host',latest='$latest'" .
			   " WHERE jobid = \"$jobid\"");
    $query2->execute;
  }
} 

sub getJobCount {
  ## for non
  $query = $dbh->prepare("SELECT COUNT(jobid) as count FROM $task WHERE (status != 'complete' && status != 'running')");
  $query->execute;
  ($count) = $query->fetchrow_array;
  ## print 'count=', $count, "\n";
  return($count);
}

## 
## mGetopts.pl - a better getopt.pl
## Usage:
##      do mGetopts('a:|type:|logic|c:');
## -a, -type, -c take arg. -logic not. Sets opt_* as a side effect.
##
## in unix shell, setenv PERLLIB $HOME/perl/lib
## require 'mGetopts.pl';
##
## Example: 
## $opt_a = 1;
## $opt_type = "New";
## $opt_logic;
## $opt_c = 10;
## 
## &mGetopts('a:|type:|logic|c:');
## ## print the rest args
## for($elm=0; $elm<=$#ARGV; $elm++) {
##   print "ARGV[$elm]= <$ARGV[$elm]>\n";
## }
## exit 0;
##
##
sub mGetopts {
  local($argumentative) = @_;
  local(@args_template,$key,@grep_result,$keyFull);
  local($errs) = 0; 
  local($[) = 0; ## array index starts at 0
  ##
  $argumentative =~ s/ +//g;
  ## print STDERR "$argumentative\n";
  ##
  @args_template = split( /\|/, $argumentative ); 
  ## print STDERR join(' ', @args_template), "\n";
  ##
  while(@ARGV && ($ARGV[0]) =~ /^-(\S+)/) {
    $key = $1;
    @grep_result = grep(/^${key}/, @args_template);
    if( scalar(@grep_result) == 1 ) {
      $keyFull = $grep_result[0]; $keyFull =~ s/://;
      if( $grep_result[0] =~ /:/ ) {
	if( scalar(@ARGV) <= 1 ) {
	  print STDERR "option $key needs arg\n";
	  goto USAGE;
	} else {
	  shift(@ARGV);
	  eval "\$opt_$keyFull = \"$ARGV[0]\";";
	  print STDERR "\$opt_$keyFull= $ARGV[0]\n";
	}
      } else {
	eval "\$opt_$keyFull = 1;";
	print STDERR "\$opt_$keyFull= 1\n";
      }
    } else {
      print STDERR "unknown option $key\n";
    USAGE:
      print STDERR "Usage: $0\n";
      ## print STDERR "Usage:\n-", join("\n-", @args_template), "\n";
      ## ++ $err;
      foreach $arg (@args_template) {
	## print STDERR $arg, "\n";
	if($arg =~ /(^\S+):$/) {
	  print STDERR "-", $1, " arg \t(default= ", eval "\$opt_$1;", ")\n";
	} else {
	  $default = eval "\$opt_$arg;";
	  if($default) {
	    $default = "on";
	  } else {
	    $default = "off";
	  }
	  print STDERR "-", $arg, " \t(default= ", $default, ")\n";
	}
      }
      print STDERR $USAGE_STRING, "\n"; ## extra usage stuff
      exit(1);
    }
    shift(@ARGV);
  }
  $errs == 0;
}
1;
