#!/usr/bin/perl

## loadSobj.pl ns/data0/ns.rate-8.RTT.gz
## loadSobj.pl -type flow.RTT ns/data0/ns.rate-8.flow.gz

$opt_type="";
$opt_program="S"; ## "R"
&mGetopts('type:|program:');

if($opt_program eq "S") {
  $opt_program = "/usr/local/bin/Splus5";
} elsif($opt_program eq "R") {
  $opt_program="/usr/bin/R --no-save --no-restore --quiet --slave";
}

for($indx=0; $indx<=$#ARGV; $indx++) {
  print "ARGV[$indx]= <$ARGV[$indx]>\n";
  $file=$ARGV[$indx];
  &load_one_file($file);
}
## read from STDIN as well
while(<STDIN>) {
  chomp;
  $file=$_;
  &load_one_file($file);
}
exit 0;

sub load_one_file {
  local($file) = @_;
  local($type) = $opt_type;
  if($type eq "") {
    ## guess
    $type = $file;
    $type =~ s/\.gz$//;
    @flds = split(/\./, $type);
    $type = $flds[$#flds];
  } 
  print ">>> type= $type\n";
  if($opt_type eq "flow.RTT") {
      $cmd="echo 'read.flow.RTT(\"$file\")' | $opt_program";
  } else {
      $cmd="echo 'read.flow(\"$file\",type=\"$type\")' | $opt_program";
  }
  print ">>> $cmd\n";
  system($cmd);  
}

;# mGetopts.pl - a better getopt.pl
;# Usage:
;#      do mGetopts('a:|type:|logic|c:');
;# -a, -type, -c take arg. -logic not. Sets opt_* as a side effect.
##
## in unix shell, setenv PERLLIB $HOME/perl/lib
## require 'mGetopts.pl';
##
## Example: 
## $opt_a = 1;
## $opt_type = "New";
## $opt_logic;
## $opt_c = 10;
## 
## &mGetopts('a:|type:|logic|c:');
## ## print the rest args
## for($elm=0; $elm<=$#ARGV; $elm++) {
##   print "ARGV[$elm]= <$ARGV[$elm]>\n";
## }
## exit 0;
##
##
sub mGetopts {
  local($argumentative) = @_;
  local(@args_template,$key,@grep_result,$keyFull);
  local($errs) = 0; 
  local($[) = 0; ## array index starts at 0
  ##
  $argumentative =~ s/ +//g;
  ## print STDERR "$argumentative\n";
  ##
  @args_template = split( /\|/, $argumentative ); 
  ## print STDERR join(' ', @args_template), "\n";
  ##
  while(@ARGV && ($ARGV[0]) =~ /^-(\S+)/) {
    $key = $1;
    @grep_result = grep(/^${key}/, @args_template);
    if( scalar(@grep_result) == 1 ) {
      $keyFull = $grep_result[0]; $keyFull =~ s/://;
      if( $grep_result[0] =~ /:/ ) {
	if( scalar(@ARGV) <= 1 ) {
	  print STDERR "option $key needs arg\n";
	  goto USAGE;
	} else {
	  shift(@ARGV);
	  eval "\$opt_$keyFull = \"$ARGV[0]\";";
	  print STDERR "\$opt_$keyFull= $ARGV[0]\n";
	}
      } else {
	eval "\$opt_$keyFull = 1;";
	print STDERR "\$opt_$keyFull= 1\n";
      }
    } else {
      print STDERR "unknown option $key\n";
    USAGE:
      print STDERR "Usage:\n";
      ## print STDERR "Usage:\n-", join("\n-", @args_template), "\n";
      ## ++ $err;
      foreach $arg (@args_template) {
	## print STDERR $arg, "\n";
	if($arg =~ /(^\S+):$/) {
	  print STDERR "-", $1, " arg \t(default= ", eval "\$opt_$1;", ")\n";
	} else {
	  $default = eval "\$opt_$arg;";
	  if($default) {
	    $default = "on";
	  } else {
	    $default = "off";
	  }
	  print STDERR "-", $arg, " \t(default= ", $default, ")\n";
	}
      }
      exit(1);
    }
    shift(@ARGV);
  }
  $errs == 0;
}
1;
