#!/usr/bin/perl
##
## Copyright (c) 1998-2000, Statistics Research, Bell Labs, Lucent Technologies.
##   All rights reserved.
## 
## This program is a part of the S-Net Project: a distributed data
## analysis computing environment for Internet traffic data.
##

##
## $Id: tcpasc2pac.pl,v 1.18 2001/10/24 14:09:58 dxsun Exp $
##

## Input format from:
## "tcpdump -tt -n -r - ip proto \\tcp" 
## Output format:
## time ip0 port0 ip1 port1 dir flag seq len ack win mss
## 
## ip0,port0 correspond to the ip,port with smaller port number 
##   or smaller ip when port numbers are the same
## dir: 0 when ip0 is the source port
##      1 when ip1 is the source port
## flag: select from UAPRSF, (URG, ACK, PSH, RST, SYN, FIN)
## seq: NA if len is 0
## ack: NA if "A" is not in flag
## mss: NA if "S" is not in flag

## Note:
## option fields are difficult to deal with, for example:
## S 2049277440:2049277440(0) win 16616 <mss 1460,wscale 0,eol> (DF)
##
## 6/1/00: modified to handle a slightly different format from tcpdump
##         on zeus.mcnc.org
## 7/5/01: for simulation traces (NS-PackMime), we often have the 
##         same port number on server and client, so we have a need to
##         explicitly specify the IPs of server.
##         The current proposal is to look for a file named "tcpasc2pac.server_ips"
##         with a list of ips in text format. Ignore it if it is not found in the current
##         processing directory

$opt_header=0; ## print header as the first line if opt_header=1

&mGetopts('header');

$SERVER_IPS_FILE="tcpasc2pac.server_ips";
$USE_SERVER_IPS=0;
if( -e $SERVER_IPS_FILE ) {
  $USE_SERVER_IPS=1;
  open(FILE, $SERVER_IPS_FILE) || print STDERR "cannot open \"$SERVER_IPS_FILE\"\n";
  print STDERR ">>> reading server_ips from \"$SERVER_IPS_FILE\"\n";
  while(<FILE>) {
    chomp;
    $server_ips{$_}=$_;
    print STDERR ">>> server_ip: $_\n";
  }
  close(FILE);
}

## print "time ip0 port0 ip1 port1 dir flag seq len ack win mss\n";
if($opt_header) {
  print "1:time 2:ip0 3:port0 4:ip1 5:port1 6:dir 7:flag 8:seq 9:len 10:ack 11:win 12:mss\n";
}
`echo 1:time 2:ip0 3:port0 4:ip1 5:port1 6:dir 7:flag 8:seq 9:len 10:ack 11:win 12:mss > tcppac.header`;

while($line=<STDIN>) {
  chop $line;
  if($line =~ /^(\S+) ([0-9]+.[0-9]+.[0-9]+.[0-9]+).([0-9]+) > ([0-9]+.[0-9]+.[0-9]+.[0-9]+).([0-9]+): (\S+) (.+)$/) { 
    $time = $1;
    $sip = $2;
    $sport = $3;
    $dip = $4;
    $dport = $5;
    $flag = $6;
    $lineRest = $7;
    ## $seq = $ack = $win =  $mss = "NA";
    $seq = $ack = $win =  $mss = 0; ## "NA" cause problem in read as integer
    $len = 0;
    if($lineRest =~ /ack (\d+)/) {
      $ack = $1;
      if($flag eq ".") {
	$flag = "A";
      } else {
	$flag .= "A";
      }
    }
    if($lineRest =~ /win (\d+)/) {
      $win = $1;
    }
    if($lineRest =~ /(\d+):\d+[(](\d+)[)]/) {
      $seq = $1;
      $len = $2;
    }
    if($lineRest =~ /<([^\>]+)>/) {
      $tcpopt = $1;
      if($tcpopt =~ /mss (\d+)/) {
	$mss = $1;
      }
      ## you could put more options here if needed.
    }
    
    ## assume that it is impossible to have sip==dip case
    if( $USE_SERVER_IPS == 0) {
      if( ($sport < $dport) || (($sport == $dport) && ($sip < $dip)) ) {
	$dir = 0;
	$ip0 = $sip; $port0 = $sport;
	$ip1 = $dip; $port1 = $dport;
      } else {
	$dir = 1;
	$ip1 = $sip; $port1 = $sport;
	$ip0 = $dip; $port0 = $dport;
      }
    } else {
      if(defined($server_ips{$sip})) {
	$dir = 0;
	$ip0 = $sip; $port0 = $sport;
	$ip1 = $dip; $port1 = $dport;
      } elsif(defined($server_ips{$dip})) {
	$dir = 1;
	$ip1 = $sip; $port1 = $sport;
	$ip0 = $dip; $port0 = $dport;
      } else {
	print STDERR ">>> cannot determine server between $sip and $dip, exit.\n";
	exit(1);
      }
    }

    if(0) {
      if($flag =~ /S/ && $mss == 0) {
        print STDERR ">>> Warning: flag= $flag, mss= $mss, $line\n";
      }
    }
    print "$time $ip0 $port0 $ip1 $port1 $dir $flag $seq $len $ack $win $mss\n";
  } else {
    print STDERR ">>> Warning unable to decode line: $line\n";
    ## print STDERR ">>> Try using tcpdump this way: tcpdump -tt -n -r - ip proto \\\\tcp\n";
  }
}
exit(0); 


;# mGetopts.pl - a better getopt.pl
;# Usage:
;#      do mGetopts('a:|type:|logic|c:');
;# -a, -type, -c take arg. -logic not. Sets opt_* as a side effect.
##
## in unix shell, setenv PERLLIB $HOME/perl/lib
## require 'mGetopts.pl';
##
## Example: 
## $opt_a = 1;
## $opt_type = "New";
## $opt_logic;
## $opt_c = 10;
## 
## &mGetopts('a:|type:|logic|c:');
## ## print the rest args
## for($elm=0; $elm<=$#ARGV; $elm++) {
##   print "ARGV[$elm]= <$ARGV[$elm]>\n";
## }
## exit 0;
##
##
sub mGetopts {
  local($argumentative) = @_;
  local(@args_template,$key,@grep_result,$keyFull);
  local($errs) = 0; 
  local($[) = 0; ## array index starts at 0
  ##
  $argumentative =~ s/ +//g;
  ## print STDERR "$argumentative\n";
  ##
  @args_template = split( /\|/, $argumentative ); 
  ## print STDERR join(' ', @args_template), "\n";
  ##
  while(@ARGV && ($ARGV[0]) =~ /^-(\S+)/) {
    $key = $1;
    @grep_result = grep(/^${key}/, @args_template);
    if( scalar(@grep_result) == 1 ) {
      $keyFull = $grep_result[0]; $keyFull =~ s/://;
      if( $grep_result[0] =~ /:/ ) {
	if( scalar(@ARGV) <= 1 ) {
	  print STDERR "option $key needs arg\n";
	  goto USAGE;
	} else {
	  shift(@ARGV);
	  eval "\$opt_$keyFull = \"$ARGV[0]\";";
	  print STDERR "\$opt_$keyFull= $ARGV[0]\n";
	}
      } else {
	eval "\$opt_$keyFull = 1;";
	print STDERR "\$opt_$keyFull= 1\n";
      }
    } else {
      print STDERR "unknown option $key\n";
    USAGE:
      print STDERR "Usage:\n";
      ## print STDERR "Usage:\n-", join("\n-", @args_template), "\n";
      ## ++ $err;
      foreach $arg (@args_template) {
	## print STDERR $arg, "\n";
	if($arg =~ /(^\S+):$/) {
	  print STDERR "-", $1, " arg \t(default= ", eval "\$opt_$1;", ")\n";
	} else {
	  $default = eval "\$opt_$arg;";
	  if($default) {
	    $default = "on";
	  } else {
	    $default = "off";
	  }
	  print STDERR "-", $arg, " \t(default= ", $default, ")\n";
	}
      }
      exit(1);
    }
    shift(@ARGV);
  }
  $errs == 0;
}
1;
