eval 'exec `which perl` -S $0 ${1+"$@"}'
 if 0;
#!/usr/local/bin/perl

##
## $Id: tcppac_split.pl,v 1.8 2000/11/09 18:34:26 dxsun Exp dxsun $
## $Source: /home/dxsun/Project/Packet/Src/script/RCS/tcppac_split.pl,v $
##

## read in .tcppac file (from tcpdump2asc.sh | tcpasc2pac.pl)
## and append the packets to files arranged by days with a fixed 
## file name, such as:
## 99_01_06.tcppac
##
## Usage:
## gzip -cdfq Tue_Nov_17_18_26_17_1998.tcpdump \
##   | tcpdump2asc.sh | tcpasc2pac.pl | tcppac_split.pl -by day
## OR
## gzip -cdfq Tue_Nov_17_18_26_17_1998.tcpdump \
##   | tcpdump2asc.sh | tcpasc2pac.pl | tcppac_split.pl -by hour
##

## assume all packets are already sorted by time
## NOTE: ctime() convert from unix seconds to crrent time
## with the right timezone (automatically adjusted for day light savings time)

## 7/5/99
## each line in tcppac file is about 100 bytes, and the maximum file size
## allowed on linux system is 2GB, so only a max of 20M packets can be 
## accomodated in one tcppac file (10M is probably on the easy side for
## subsequent processing)
## so use -by "hour" if the daily file is likely to exceed 20M packets
##

## 11/09/00: 
## split any file by a field of timestamp, not necessarily tcppac files
##

$opt_USEGZ=1; ## if 1, use gzip whenever files are created to save space
$opt_by="day"; ## or "hour", or number of packets such as "100000".
$opt_tsfield=1; ## which field to use as the timestamp
$opt_suffix="tcppac";
$opt_prefix="";

&mGetopts('USEGZ:|by:|tsfield:|prefix:|suffix:');

$oldtime=0;
while($line=<>) {
  if($line =~ /^(\S+)\s/) {
    ## $time = $1;
    @flds = split(/ /, $line);
    $time = $flds[($opt_tsfield)-1];
    if($time < $oldtime) {
      print STDERR ">>> Error, timestamp should be sorted first\n"; 
      exit(1);
    }
    $oldtime = $time;

    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($time);
    $year += 1900; ## Y2K problem ?
    ## break into a new file when day change or hour change
    if($opt_by eq "day") {
      $code=sprintf("%04d.%02d.%02d", $year,$mon+1,$mday);
    } elsif($opt_by eq "hour") {
      $code=sprintf("%04d.%02d.%02d.h%02d", $year,$mon+1,$mday,$hour);
    } elsif($opt_by eq "15min") {
      $code=sprintf("%04d.%02d.%02d.h%02d.m%02d.%02d", $year,$mon+1,$mday,$hour,
		    $min-($min % 15), 15+$min-($min % 15));
    } elsif($opt_by eq "5min") {
      $code=sprintf("%04d.%02d.%02d.h%02d.m%02d.%02d", $year,$mon+1,$mday,$hour,
		    $min-($min % 5), 5+$min-($min % 5));
    } elsif($opt_by eq "1min") {
      $code=sprintf("%04d.%02d.%02d.h%02d.m%02d.%02d", $year,$mon+1,$mday,$hour,
		    $min-($min % 1), 1+$min-($min % 1));
    } elsif($opt_by eq "15sec") {
      $code=sprintf("%04d.%02d.%02d.h%02d.m%02d.s%02d.s%02d",
		    $year,$mon+1,$mday,$hour,$min,
		    $sec-($sec % 15), 15+$sec-($sec % 15));
    } elsif($opt_by eq "5sec") {
      $code=sprintf("%04d.%02d.%02d.h%02d.m%02d.s%02d.s%02d", 
		    $year,$mon+1,$mday,$hour,$min,
		    $sec-($sec % 5), 5+$sec-($sec % 5));
    } elsif($opt_by eq "1sec") {
      $code=sprintf("%04d.%02d.%02d.h%02d.m%02d.s%02d.s%02d",
		    $year,$mon+1,$mday,$hour,$min,
		    $sec-($sec % 1), 1+$sec-($sec % 1));
    } else {
      print STDERR ">>> unknown by <$opt_by>\n";
      exit(1);
    }

    if($code ne $cur_code) { ## switch to a new file
      $prefix = $code;
      if($cur_code ne "") {
	close(FILE);
      } else {
	## if this is the first hour block, modified the file name
	## a little bit to distinguish that from a previous block
        ## it is not very useful to have this feature of adding "+" to file name
	## $prefix = $prefix . "+";
      }
      if($opt_USEGZ) { 
	$fileName = $prefix . "." . $opt_suffix . ".gz";
	if($opt_prefix ne "") {
	  $fileName = $opt_prefix . "." . $fileName;
	}	
	open(FILE, "|gzip>$fileName") || die("cannot open |gzip>$fileName");
      } else {
	$fileName = $prefix . "." . $opt_suffix;
	if($opt_prefix ne "") {
	  $fileName = $opt_prefix . "." . $fileName;
	}	
	open(FILE, ">$fileName") || die("cannot open >$fileName");
      }
      print STDERR ">>> writing to $fileName\n";
    }
    $cur_code = $code;
    printf FILE $line;
  }
}
close(FILE);
exit(0);

##
## mGetopts.pl - a better getopt.pl
## Usage:
##      do mGetopts('a:|type:|logic|c:');
## -a, -type, -c take arg. -logic not. Sets opt_* as a side effect.
##
## in unix shell, setenv PERLLIB $HOME/perl/lib
## require 'mGetopts.pl';
##
## Example: 
## $opt_a = 1;
## $opt_type = "New";
## $opt_logic;
## $opt_c = 10;
## 
## &mGetopts('a:|type:|logic|c:');
## ## print the rest args
## for($elm=0; $elm<=$#ARGV; $elm++) {
##   print "ARGV[$elm]= <$ARGV[$elm]>\n";
## }
## exit 0;
##
##
sub mGetopts {
  local($argumentative) = @_;
  local(@args_template,$key,@grep_result,$keyFull);
  local($errs) = 0; 
  local($[) = 0; ## array index starts at 0
  ##
  $argumentative =~ s/ +//g;
  ## print STDERR "$argumentative\n";
  ##
  @args_template = split( /\|/, $argumentative ); 
  ## print STDERR join(' ', @args_template), "\n";
  ##
  while(@ARGV && ($ARGV[0]) =~ /^-(\S+)/) {
    $key = $1;
    @grep_result = grep(/^${key}/, @args_template);
    if( scalar(@grep_result) == 1 ) {
      $keyFull = $grep_result[0]; $keyFull =~ s/://;
      if( $grep_result[0] =~ /:/ ) {
	if( scalar(@ARGV) <= 1 ) {
	  print STDERR "option $key needs arg\n";
	  goto USAGE;
	} else {
	  shift(@ARGV);
	  eval "\$opt_$keyFull = \"$ARGV[0]\";";
	  print STDERR "\$opt_$keyFull= $ARGV[0]\n";
	}
      } else {
	eval "\$opt_$keyFull = 1;";
	print STDERR "\$opt_$keyFull= 1\n";
      }
    } else {
      print STDERR "unknown option $key\n";
    USAGE:
      print STDERR "Usage:\n";
      ## print STDERR "Usage:\n-", join("\n-", @args_template), "\n";
      ## ++ $err;
      foreach $arg (@args_template) {
	## print STDERR $arg, "\n";
	if($arg =~ /(^\S+):$/) {
	  print STDERR "-", $1, " arg \t(default= ", eval "\$opt_$1;", ")\n";
	} else {
	  $default = eval "\$opt_$arg;";
	  if($default) {
	    $default = "on";
	  } else {
	    $default = "off";
	  }
	  print STDERR "-", $arg, " \t(default= ", $default, ")\n";
	}
      }
      print STDERR $USAGE_STRING, "\n"; ## extra usage stuff
      exit(1);
    }
    shift(@ARGV);
  }
  $errs == 0;
}
1;
