\name{fit.fsd.log10spec.unbiased}
\alias{fit.fsd.log10spec.unbiased}
\title{ Fitting FSD Model }
\description{
  Fitting Fractional Sum Difference (FSD) Model 
}
\usage{
fit.fsd.log10spec.unbiased(x, log10spec.obs.lst, 
                                  spec.pgram.arg=list(),
                                  init=NULL, type="p3",
                                  p2a.d=NULL, 
                                  freq.var=c(0.01,0.025,0.05))
}
\arguments{
  \item{x}{ time series. }
  \item{log10spec.obs.lst}{}
  \item{spec.pgram.arg}{ arguments passed on to the spec.pgram() function }
  \item{init}{ initial parameters }
  \item{type}{ \code{p1}, \code{p2}, or \code{p3}.
    \code{p3}: optimize for varRatio, d, sigma.lSq;
    \code{p2a}: optimize for varRatio, sigma.lSq;
    \code{p2}: optimize for varRatio, d;
    \code{p1}: optimize for varRatio;}
  \item{p2a.d}{ p2a.d }
  \item{freq.var}{ freq.var }
}
\value{
  An object of the fitted model.
}
\details{
 More material needed here.
}
\author{Jin Cao \email{cao@bell-labs.com},
        William S. Cleveland \email{wsc@bell-labs.com},
	Don X. Sun \email{dxsun@bell-labs.com},
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{
  \code{\link{spectrum.plot}}
}
\examples{
objNm _ "My Data"
x _ rnorm(1000) + sin(seq(1000)/50*pi); plot(x, type="l")
if(exists("fracdiff.sim")) {
  d <- 0.25; x <- fracdiff.sim(n=1000, ar=0, ma=-1, d=d)$series
}
fit _ fit.fsd.log10spec.unbiased(x, type="p2")
fit _ fit.fsd.log10spec.unbiased(fit, label=list(main=objNm))
fit _ fit.fsd.log10spec.unbiased(fit, xscal="sqrt", label=list(main=objNm))
fit _ fit.fsd.log10spec.unbiased(fit, label=list(main=objNm), psfile="demo.ps")
fit _ fit.fsd.log10spec.unbiased(fit, xscale="original", label=list(main=objNm), psfile="demo.ps")
fit _ fit.fsd.log10spec.unbiased(fit, label=list(main=objNm), type="geweke.residual", psfile="demo.ps")
fit _ fit.fsd.log10spec.unbiased(fit, label=list(main=objNm), type="fit.residual", psfile="demo.ps")
}
\keyword{dplot}

