\name{get.intvl.df}
\alias{get.intvl.df}
\title{ Run Interval Task }
\description{
  Carry out time block/interval analysis
}
\usage{
get.intvl.df(objLst, type, TIMESTAMP.OPTION, pacSize.type, LINKSPEED)
}
\arguments{
  \item{objLst}{ a vector of interval object names }
  \item{type}{ "pac" or "flow" }
  \item{TIMESTAMP.OPTION} { "pac.end" or "pac.start", indicating whether
    timestamp is done at the beginning of packet or at the end of the
    packet}
  \item{pacSize.type}{ "ETH.PAYLOAD", "ETH.ETH", "ETH.IP", "ATM/AAL5",
    "POS/PPP", or "SIMU":  packet encapsulation type}
  \item{LINKSPEED}{ link speed in mbits/sec }
}
\value{
  a data frame with "objnme", "flowrate" for type=="flow" and a data
  frame with "objnme", "pacrate", "TIMESTAMP.OPTION", "pacSize.type",
  "LINKSPEED" for type=="pac"
}
\details{
}
\author{Jin Cao \url{cao@bell-labs.com},
        William S. Cleveland \url{wsc@bell-labs.com},
	Don X. Sun \url{dxsun@bell-labs.com}
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{
  \code{\link{run.intvl.task}}
}
\examples{
objLst _ drop.names(unlist(ols("flow.anony.2000.03.08.*m30.35")))[1:2]; objLst
task.subset.samp.df _ get.intvl.df(objLst, type="flow")
}
\keyword{dplot}

