\name{normal.qqplot}
\alias{normal.qqplot}
\title{ Normal Q-Q Plot }
\description{
  Quantile-Quantile plot of a sample and a theoretical Normal distribution
}
\usage{
normal.qqplot(y, label=list(), psfile="", append=F, horizontal=F, ...)
}
\arguments{
  \item{y}{ the variable to be plotted. }
  \item{label}{ an optinal list for supplying user-defined \code{xlab},
    \code{ylab}, \code{main}, \code{sub}, \code{labels} }
  \item{psfile}{ file name for saving plot to a postscript file }
  \item{append}{ arguments to the \code{trellis.device} function. }
  \item{horizontal}{ arguments to the \code{trellis.device} function. }
  \item{\dots}{ other arguments passed on to \code{qqmath}. }
}
\value{
  An object of class trellis, by default plotted by \code{print.trellis}.
}
\details{
  This is a customized plot using the generic plot function \code{qqmath}.
}
\author{Jin Cao \email{cao@bell-labs.com},
        William S. Cleveland \email{wsc@bell-labs.com},
	Don X. Sun \email{dxsun@bell-labs.com},
        \url{http://cm.bell-labs.com/stat/InternetTraffic/S-Net}
}
\seealso{
  \code{\link{time.plot}},
  \code{\link{unif.qqplot}},
  \code{\link{weibull.qqplot}},
  \code{\link{normal.qqplot}},
  \code{\link{pareto.qqplot}},
  \code{\link{spectrum.plot}},
}
\examples{
y = rnorm(1000)
normal.qqplot(y)
subStr = paste("normal quantile plot")
normal.qqplot(y, label=list(sub=subStr))
normal.qqplot(y, label=list(sub=subStr), psfile="demo.ps")
}
\keyword{dplot}

